/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.control;

import io.grpc.stub.StreamObserver;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.runners.fnexecution.control.FnApiControlClient;
import org.apache.beam.runners.fnexecution.control.FnApiControlClientPoolService;
import org.apache.beam.sdk.util.MoreFutures;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class FnApiControlClientPoolServiceTest {
    private final BlockingQueue<FnApiControlClient> pool = new LinkedBlockingQueue<FnApiControlClient>();
    private FnApiControlClientPoolService controlService = FnApiControlClientPoolService.offeringClientsToPool(this.pool);

    @Test
    public void testIncomingConnection() throws Exception {
        StreamObserver requestObserver = (StreamObserver)Mockito.mock(StreamObserver.class);
        StreamObserver responseObserver = this.controlService.control(requestObserver);
        FnApiControlClient client = this.pool.take();
        String id = "fakeInstruction";
        CompletionStage responseFuture = client.handle(BeamFnApi.InstructionRequest.newBuilder().setInstructionId(id).build());
        ((StreamObserver)Mockito.verify((Object)requestObserver)).onNext(Matchers.any(BeamFnApi.InstructionRequest.class));
        Assert.assertThat((Object)MoreFutures.isDone((CompletionStage)responseFuture), (Matcher)org.hamcrest.Matchers.is((Object)false));
        responseObserver.onNext((Object)BeamFnApi.InstructionResponse.newBuilder().setInstructionId(id).build());
        MoreFutures.get((CompletionStage)responseFuture);
    }
}

