/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.state;

import java.util.EnumMap;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.runners.fnexecution.state.StateRequestHandler;
import org.apache.beam.runners.fnexecution.state.StateRequestHandlers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class StateRequestHandlersTest {
    @Test
    public void testDelegatingStateHandlerDelegates() throws Exception {
        StateRequestHandler mockHandler = (StateRequestHandler)Mockito.mock(StateRequestHandler.class);
        StateRequestHandler mockHandler2 = (StateRequestHandler)Mockito.mock(StateRequestHandler.class);
        EnumMap<BeamFnApi.StateKey.TypeCase, StateRequestHandler> handlers = new EnumMap<BeamFnApi.StateKey.TypeCase, StateRequestHandler>(BeamFnApi.StateKey.TypeCase.class);
        handlers.put(BeamFnApi.StateKey.TypeCase.TYPE_NOT_SET, mockHandler);
        handlers.put(BeamFnApi.StateKey.TypeCase.MULTIMAP_SIDE_INPUT, mockHandler2);
        BeamFnApi.StateRequest request = BeamFnApi.StateRequest.getDefaultInstance();
        BeamFnApi.StateRequest request2 = BeamFnApi.StateRequest.newBuilder().setStateKey(BeamFnApi.StateKey.newBuilder().setMultimapSideInput(BeamFnApi.StateKey.MultimapSideInput.getDefaultInstance())).build();
        StateRequestHandlers.delegateBasedUponType(handlers).handle(request);
        StateRequestHandlers.delegateBasedUponType(handlers).handle(request2);
        ((StateRequestHandler)Mockito.verify((Object)mockHandler)).handle(request);
        ((StateRequestHandler)Mockito.verify((Object)mockHandler2)).handle(request2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockHandler, mockHandler2});
    }

    @Test
    public void testDelegatingStateHandlerThrowsWhenNotFound() throws Exception {
        StateRequestHandlers.delegateBasedUponType(new EnumMap(BeamFnApi.StateKey.TypeCase.class)).handle(BeamFnApi.StateRequest.getDefaultInstance());
    }
}

