/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.jobsubmission;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.beam.model.jobmanagement.v1.ArtifactApi;
import org.apache.beam.runners.fnexecution.jobsubmission.PortablePipelineJarCreator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class PortablePipelineJarCreatorTest
implements Serializable {
    @Mock
    private JarFile inputJar;
    @Mock
    private JarOutputStream outputStream;
    @Mock
    private WritableByteChannel outputChannel;
    @Mock
    private PortablePipelineJarCreator.ArtifactRetriever retrievalServiceStub;
    private PortablePipelineJarCreator jarCreator;

    @Before
    public void setup() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        JarInputStream emptyInputStream = new JarInputStream(new ByteArrayInputStream(new byte[0]));
        Mockito.when((Object)this.inputJar.getInputStream((ZipEntry)org.mockito.Matchers.any())).thenReturn((Object)emptyInputStream);
        Mockito.when((Object)this.retrievalServiceStub.getArtifact((ArtifactApi.GetArtifactRequest)org.mockito.Matchers.any())).thenReturn(Collections.emptyIterator());
        this.jarCreator = new PortablePipelineJarCreator(null);
        this.jarCreator.outputStream = this.outputStream;
        this.jarCreator.outputChannel = this.outputChannel;
    }

    @Test
    public void testCopyResourcesFromJar_copiesResources() throws IOException {
        ImmutableList entries = ImmutableList.of((Object)new JarEntry("foo"), (Object)new JarEntry("bar"), (Object)new JarEntry("baz"));
        Mockito.when(this.inputJar.entries()).thenReturn(Collections.enumeration(entries));
        this.jarCreator.copyResourcesFromJar(this.inputJar);
        ((JarOutputStream)Mockito.verify((Object)this.outputStream, (VerificationMode)Mockito.times((int)3))).putNextEntry((ZipEntry)org.mockito.Matchers.any());
    }

    @Test
    public void testCopyResourcesFromJar_ignoresManifest() throws IOException {
        ImmutableList manifestEntry = ImmutableList.of((Object)new JarEntry("META-INF/MANIFEST.MF"));
        Mockito.when(this.inputJar.entries()).thenReturn(Collections.enumeration(manifestEntry));
        this.jarCreator.copyResourcesFromJar(this.inputJar);
        ((JarOutputStream)Mockito.verify((Object)this.outputStream, (VerificationMode)Mockito.never())).putNextEntry((ZipEntry)org.mockito.Matchers.any());
    }

    @Test
    public void testCopyResourcesFromJar_ignoresDuplicates() throws IOException {
        ImmutableList duplicateEntries = ImmutableList.of((Object)new JarEntry("foo"), (Object)new JarEntry("foo"));
        Mockito.when(this.inputJar.entries()).thenReturn(Collections.enumeration(duplicateEntries));
        this.jarCreator.copyResourcesFromJar(this.inputJar);
        ((JarOutputStream)Mockito.verify((Object)this.outputStream, (VerificationMode)Mockito.times((int)1))).putNextEntry((ZipEntry)org.mockito.Matchers.any());
    }

    @Test
    public void testCopyStagedArtifacts_returnsProxyManifest() throws IOException {
        ArtifactApi.ArtifactMetadata artifact1 = ArtifactApi.ArtifactMetadata.newBuilder().setName("foo").build();
        ArtifactApi.ArtifactMetadata artifact2 = ArtifactApi.ArtifactMetadata.newBuilder().setName("bar").build();
        ImmutableList artifacts = ImmutableList.of((Object)artifact1, (Object)artifact2);
        ArtifactApi.Manifest manifest = ArtifactApi.Manifest.newBuilder().addAllArtifact((Iterable)artifacts).build();
        Mockito.when((Object)this.retrievalServiceStub.getManifest((ArtifactApi.GetManifestRequest)org.mockito.Matchers.any())).thenReturn((Object)ArtifactApi.GetManifestResponse.newBuilder().setManifest(manifest).build());
        ArtifactApi.ProxyManifest proxyManifest = this.jarCreator.copyStagedArtifacts("retrievalToken", this.retrievalServiceStub);
        Assert.assertEquals((Object)manifest, (Object)proxyManifest.getManifest());
        List outputArtifactNames = proxyManifest.getLocationList().stream().map(ArtifactApi.ProxyManifest.Location::getName).collect(Collectors.toList());
        Assert.assertThat(outputArtifactNames, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"foo", "bar"}));
    }

    @Test
    public void testCopyStagedArtifacts_copiesArtifacts() throws IOException {
        ArtifactApi.ArtifactMetadata artifact1 = ArtifactApi.ArtifactMetadata.newBuilder().setName("foo").build();
        ArtifactApi.ArtifactMetadata artifact2 = ArtifactApi.ArtifactMetadata.newBuilder().setName("bar").build();
        ImmutableList artifacts = ImmutableList.of((Object)artifact1, (Object)artifact2);
        ArtifactApi.Manifest manifest = ArtifactApi.Manifest.newBuilder().addAllArtifact((Iterable)artifacts).build();
        Mockito.when((Object)this.retrievalServiceStub.getManifest((ArtifactApi.GetManifestRequest)org.mockito.Matchers.any())).thenReturn((Object)ArtifactApi.GetManifestResponse.newBuilder().setManifest(manifest).build());
        this.jarCreator.copyStagedArtifacts("retrievalToken", this.retrievalServiceStub);
        ((JarOutputStream)Mockito.verify((Object)this.outputStream, (VerificationMode)Mockito.times((int)2))).putNextEntry((ZipEntry)org.mockito.Matchers.any());
    }

    @Test
    public void testCreateManifest_withMainMethod() {
        Manifest manifest = this.jarCreator.createManifest(FakePipelineRunnner.class);
        Assert.assertEquals((Object)FakePipelineRunnner.class.getName(), (Object)manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS));
    }

    @Test
    public void testCreateManifest_withoutMainMethod() {
        Manifest manifest = this.jarCreator.createManifest(EmptyPipelineRunner.class);
        Assert.assertNull((Object)manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS));
    }

    @Test
    public void testCreateManifest_withInvalidMainMethod() {
        Manifest manifest = this.jarCreator.createManifest(EvilPipelineRunner.class);
        Assert.assertNull((Object)manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS));
    }

    private static class EvilPipelineRunner {
        private EvilPipelineRunner() {
        }

        public static int main(String[] args) {
            return 0;
        }
    }

    private static class EmptyPipelineRunner {
        private EmptyPipelineRunner() {
        }
    }

    private static class FakePipelineRunnner {
        private FakePipelineRunnner() {
        }

        public static void main(String[] args) {
            System.out.println("Hello world");
        }
    }
}

