/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.jobsubmission;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.fnexecution.jobsubmission.InMemoryJobService;
import org.apache.beam.runners.fnexecution.jobsubmission.JobInvocation;
import org.apache.beam.runners.fnexecution.jobsubmission.JobInvoker;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.Struct;
import org.apache.beam.vendor.grpc.v1p21p0.io.grpc.StatusException;
import org.apache.beam.vendor.grpc.v1p21p0.io.grpc.stub.StreamObserver;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class InMemoryJobServiceTest {
    private static final String TEST_JOB_NAME = "test-job";
    private static final String TEST_JOB_ID = "test-job-id";
    private static final String TEST_RETRIEVAL_TOKEN = "test-staging-token";
    private static final RunnerApi.Pipeline TEST_PIPELINE = RunnerApi.Pipeline.getDefaultInstance();
    private static final Struct TEST_OPTIONS = Struct.getDefaultInstance();
    private static final JobApi.JobInfo TEST_JOB_INFO = JobApi.JobInfo.newBuilder().setJobId("test-job-id").setJobName("test-job").setPipelineOptions(TEST_OPTIONS).build();
    Endpoints.ApiServiceDescriptor stagingServiceDescriptor;
    @Mock
    JobInvoker invoker;
    @Mock
    JobInvocation invocation;
    InMemoryJobService service;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.stagingServiceDescriptor = Endpoints.ApiServiceDescriptor.getDefaultInstance();
        this.service = InMemoryJobService.create((Endpoints.ApiServiceDescriptor)this.stagingServiceDescriptor, session -> "token", null, (JobInvoker)this.invoker);
        Mockito.when((Object)this.invoker.invoke(TEST_PIPELINE, TEST_OPTIONS, TEST_RETRIEVAL_TOKEN)).thenReturn((Object)this.invocation);
        Mockito.when((Object)this.invocation.getId()).thenReturn((Object)TEST_JOB_ID);
        Mockito.when((Object)this.invocation.getPipeline()).thenReturn((Object)TEST_PIPELINE);
        Mockito.when((Object)this.invocation.toProto()).thenReturn((Object)TEST_JOB_INFO);
    }

    private JobApi.PrepareJobResponse prepareJob() {
        JobApi.PrepareJobRequest request = JobApi.PrepareJobRequest.newBuilder().setJobName(TEST_JOB_NAME).setPipeline(RunnerApi.Pipeline.getDefaultInstance()).setPipelineOptions(Struct.getDefaultInstance()).build();
        RecordingObserver recorder = new RecordingObserver();
        this.service.prepare(request, recorder);
        return (JobApi.PrepareJobResponse)recorder.values.get(0);
    }

    private JobApi.RunJobResponse runJob(String preparationId) {
        JobApi.RunJobRequest runRequest = JobApi.RunJobRequest.newBuilder().setPreparationId(preparationId).setRetrievalToken(TEST_RETRIEVAL_TOKEN).build();
        RecordingObserver recorder = new RecordingObserver();
        this.service.run(runRequest, recorder);
        return (JobApi.RunJobResponse)recorder.values.get(0);
    }

    private JobApi.RunJobResponse prepareAndRunJob() {
        JobApi.PrepareJobResponse prepareResponse = this.prepareJob();
        return this.runJob(prepareResponse.getPreparationId());
    }

    @Test
    public void testPrepareIsSuccessful() {
        JobApi.PrepareJobRequest request = JobApi.PrepareJobRequest.newBuilder().setJobName(TEST_JOB_NAME).setPipeline(RunnerApi.Pipeline.getDefaultInstance()).setPipelineOptions(Struct.getDefaultInstance()).build();
        RecordingObserver recorder = new RecordingObserver();
        this.service.prepare(request, recorder);
        Assert.assertThat((Object)recorder.isSuccessful(), (Matcher)Is.is((Object)true));
        Assert.assertThat(recorder.values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        JobApi.PrepareJobResponse response = (JobApi.PrepareJobResponse)recorder.values.get(0);
        Assert.assertThat((Object)response.getArtifactStagingEndpoint(), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)response.getPreparationId(), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void testGetJobsIsSuccessful() throws Exception {
        this.prepareAndRunJob();
        JobApi.GetJobsRequest request = JobApi.GetJobsRequest.newBuilder().build();
        RecordingObserver recorder = new RecordingObserver();
        this.service.getJobs(request, recorder);
        Assert.assertThat((Object)recorder.isSuccessful(), (Matcher)Is.is((Object)true));
        Assert.assertThat(recorder.values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        JobApi.GetJobsResponse response = (JobApi.GetJobsResponse)recorder.values.get(0);
        List jobs = response.getJobInfoList();
        Assert.assertThat((Object)jobs, (Matcher)IsCollectionWithSize.hasSize((int)1));
        JobApi.JobInfo job = (JobApi.JobInfo)jobs.get(0);
        Assert.assertThat((Object)job.getJobId(), (Matcher)Is.is((Object)TEST_JOB_ID));
        Assert.assertThat((Object)job.getJobName(), (Matcher)Is.is((Object)TEST_JOB_NAME));
    }

    @Test
    public void testGetPipelineFailure() {
        this.prepareJob();
        JobApi.GetJobPipelineRequest request = JobApi.GetJobPipelineRequest.newBuilder().setJobId(TEST_JOB_ID).build();
        RecordingObserver recorder = new RecordingObserver();
        this.service.getPipeline(request, recorder);
        Assert.assertThat((Object)recorder.isSuccessful(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)recorder.error, (Matcher)Is.isA(StatusException.class));
    }

    @Test
    public void testGetPipelineIsSuccessful() throws Exception {
        this.prepareAndRunJob();
        JobApi.GetJobPipelineRequest request = JobApi.GetJobPipelineRequest.newBuilder().setJobId(TEST_JOB_ID).build();
        RecordingObserver recorder = new RecordingObserver();
        this.service.getPipeline(request, recorder);
        Assert.assertThat((Object)recorder.isSuccessful(), (Matcher)Is.is((Object)true));
        Assert.assertThat(recorder.values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        JobApi.GetJobPipelineResponse response = (JobApi.GetJobPipelineResponse)recorder.values.get(0);
        Assert.assertThat((Object)response.getPipeline(), (Matcher)Is.is((Object)TEST_PIPELINE));
    }

    @Test
    public void testJobSubmissionUsesJobInvokerAndIsSuccess() throws Exception {
        JobApi.PrepareJobResponse prepareResponse = this.prepareJob();
        JobApi.RunJobRequest runRequest = JobApi.RunJobRequest.newBuilder().setPreparationId(prepareResponse.getPreparationId()).setRetrievalToken(TEST_RETRIEVAL_TOKEN).build();
        RecordingObserver runRecorder = new RecordingObserver();
        this.service.run(runRequest, runRecorder);
        ((JobInvoker)Mockito.verify((Object)this.invoker, (VerificationMode)Mockito.times((int)1))).invoke(TEST_PIPELINE, TEST_OPTIONS, TEST_RETRIEVAL_TOKEN);
        Assert.assertThat((Object)runRecorder.isSuccessful(), (Matcher)Is.is((Object)true));
        Assert.assertThat(runRecorder.values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        JobApi.RunJobResponse runResponse = (JobApi.RunJobResponse)runRecorder.values.get(0);
        Assert.assertThat((Object)runResponse.getJobId(), (Matcher)Is.is((Object)TEST_JOB_ID));
        ((JobInvocation)Mockito.verify((Object)this.invocation, (VerificationMode)Mockito.times((int)1))).addStateListener((Consumer)Matchers.any());
        ((JobInvocation)Mockito.verify((Object)this.invocation, (VerificationMode)Mockito.times((int)1))).start();
    }

    private static class RecordingObserver<T>
    implements StreamObserver<T> {
        ArrayList<T> values = new ArrayList();
        Throwable error = null;
        boolean isCompleted = false;

        private RecordingObserver() {
        }

        public void onNext(T t) {
            this.values.add(t);
        }

        public void onError(Throwable throwable) {
            this.error = throwable;
        }

        public void onCompleted() {
            this.isCompleted = true;
        }

        boolean isSuccessful() {
            return this.isCompleted && this.error == null;
        }
    }
}

