/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.environment;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.beam.runners.fnexecution.environment.ProcessManager;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProcessManagerTest {
    @Test
    public void testRunSimpleCommand() throws IOException {
        ProcessManager processManager = ProcessManager.create();
        processManager.startProcess("1", "bash", Collections.emptyList());
        processManager.stopProcess("1");
        processManager.startProcess("2", "bash", Arrays.asList("-c", "ls"));
        processManager.stopProcess("2");
        processManager.startProcess("1", "bash", Arrays.asList("-c", "ls", "-l", "-a"));
        processManager.stopProcess("1");
    }

    @Test
    public void testRunInvalidExecutable() throws IOException {
        ProcessManager processManager = ProcessManager.create();
        try {
            processManager.startProcess("1", "asfasfls", Collections.emptyList());
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Cannot run program \"asfasfls\""));
        }
    }

    @Test
    public void testDuplicateId() throws IOException {
        ProcessManager processManager = ProcessManager.create();
        processManager.startProcess("1", "bash", Arrays.asList("-c", "ls"));
        try {
            processManager.startProcess("1", "bash", Arrays.asList("-c", "ls"));
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            processManager.stopProcess("1");
        }
    }

    @Test
    public void testLivenessCheck() throws IOException {
        ProcessManager processManager = ProcessManager.create();
        ProcessManager.RunningProcess process = processManager.startProcess("1", "bash", Arrays.asList("-c", "sleep", "1000"));
        process.isAliveOrThrow();
        processManager.stopProcess("1");
        try {
            process.isAliveOrThrow();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testEnvironmentVariables() throws IOException, InterruptedException {
        ProcessManager processManager = ProcessManager.create();
        ProcessManager.RunningProcess process = processManager.startProcess("1", "bash", Arrays.asList("-c", "sleep $PARAM"), Collections.singletonMap("PARAM", "-h"));
        for (int i = 0; i < 10 && process.getUnderlyingProcess().isAlive(); ++i) {
            Thread.sleep(100L);
        }
        Assert.assertThat((Object)process.getUnderlyingProcess().exitValue(), (Matcher)Matchers.is((Object)1));
        processManager.stopProcess("1");
    }
}

