/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.environment;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.Environments;
import org.apache.beam.runners.fnexecution.GrpcFnServer;
import org.apache.beam.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.runners.fnexecution.control.ControlClientPool;
import org.apache.beam.runners.fnexecution.control.FnApiControlClientPoolService;
import org.apache.beam.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.runners.fnexecution.environment.DockerCommand;
import org.apache.beam.runners.fnexecution.environment.DockerEnvironmentFactory;
import org.apache.beam.runners.fnexecution.environment.RemoteEnvironment;
import org.apache.beam.runners.fnexecution.logging.GrpcLoggingService;
import org.apache.beam.runners.fnexecution.provisioning.StaticGrpcProvisionService;
import org.apache.beam.sdk.fn.IdGenerator;
import org.apache.beam.sdk.fn.IdGenerators;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class DockerEnvironmentFactoryTest {
    private static final Endpoints.ApiServiceDescriptor SERVICE_DESCRIPTOR = Endpoints.ApiServiceDescriptor.newBuilder().setUrl("service-url").build();
    private static final String IMAGE_NAME = "my-image";
    private static final RunnerApi.Environment ENVIRONMENT = Environments.createDockerEnvironment((String)"my-image");
    private static final String CONTAINER_ID = "e4485f0f2b813b63470feacba5fe9cb89699878c095df4124abd320fd5401385";
    private static final IdGenerator ID_GENERATOR = IdGenerators.incrementingLongs();
    @Mock
    DockerCommand docker;
    @Mock
    GrpcFnServer<FnApiControlClientPoolService> controlServiceServer;
    @Mock
    GrpcFnServer<GrpcLoggingService> loggingServiceServer;
    @Mock
    GrpcFnServer<ArtifactRetrievalService> retrievalServiceServer;
    @Mock
    GrpcFnServer<StaticGrpcProvisionService> provisioningServiceServer;
    @Mock
    InstructionRequestHandler client;

    @Before
    public void initMocks() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.controlServiceServer.getApiServiceDescriptor()).thenReturn((Object)SERVICE_DESCRIPTOR);
        Mockito.when((Object)this.loggingServiceServer.getApiServiceDescriptor()).thenReturn((Object)SERVICE_DESCRIPTOR);
        Mockito.when((Object)this.retrievalServiceServer.getApiServiceDescriptor()).thenReturn((Object)SERVICE_DESCRIPTOR);
        Mockito.when((Object)this.provisioningServiceServer.getApiServiceDescriptor()).thenReturn((Object)SERVICE_DESCRIPTOR);
    }

    public static class NonParameterizedTest
    extends DockerEnvironmentFactoryTest {
        @Test
        public void createsCorrectEnvironment() throws Exception {
            Mockito.when((Object)this.docker.runImage((String)Mockito.eq((Object)DockerEnvironmentFactoryTest.IMAGE_NAME), (List)Mockito.any(), (List)Mockito.any())).thenReturn((Object)DockerEnvironmentFactoryTest.CONTAINER_ID);
            Mockito.when((Object)this.docker.isContainerRunning((String)Mockito.eq((Object)DockerEnvironmentFactoryTest.CONTAINER_ID))).thenReturn((Object)true);
            DockerEnvironmentFactory factory = this.getFactory((workerId, timeout) -> this.client);
            RemoteEnvironment handle = factory.createEnvironment(ENVIRONMENT);
            Assert.assertThat((Object)handle.getInstructionRequestHandler(), (Matcher)Matchers.is((Object)this.client));
            Assert.assertThat((Object)handle.getEnvironment(), (Matcher)Matchers.equalTo((Object)ENVIRONMENT));
        }

        @Test(expected=RuntimeException.class)
        public void logsDockerOutputOnTimeoutException() throws Exception {
            Mockito.when((Object)this.docker.runImage((String)Mockito.eq((Object)DockerEnvironmentFactoryTest.IMAGE_NAME), (List)Mockito.any(), (List)Mockito.any())).thenReturn((Object)DockerEnvironmentFactoryTest.CONTAINER_ID);
            Mockito.when((Object)this.docker.isContainerRunning((String)Mockito.eq((Object)DockerEnvironmentFactoryTest.CONTAINER_ID))).thenReturn((Object)true);
            DockerEnvironmentFactory factory = this.getFactory((workerId, timeout) -> {
                throw new TimeoutException();
            });
            factory.createEnvironment(ENVIRONMENT);
            ((DockerCommand)Mockito.verify((Object)this.docker)).getContainerLogs(DockerEnvironmentFactoryTest.CONTAINER_ID);
        }

        @Test
        public void logsDockerOutputOnClose() throws Exception {
            Mockito.when((Object)this.docker.runImage((String)Mockito.eq((Object)DockerEnvironmentFactoryTest.IMAGE_NAME), (List)Mockito.any(), (List)Mockito.any())).thenReturn((Object)DockerEnvironmentFactoryTest.CONTAINER_ID);
            Mockito.when((Object)this.docker.isContainerRunning((String)Mockito.eq((Object)DockerEnvironmentFactoryTest.CONTAINER_ID))).thenReturn((Object)true);
            DockerEnvironmentFactory factory = this.getFactory((workerId, timeout) -> this.client);
            RemoteEnvironment handle = factory.createEnvironment(ENVIRONMENT);
            handle.close();
            ((DockerCommand)Mockito.verify((Object)this.docker)).getContainerLogs(DockerEnvironmentFactoryTest.CONTAINER_ID);
        }

        @Test
        public void createsMultipleEnvironments() throws Exception {
            Mockito.when((Object)this.docker.isContainerRunning(org.mockito.Matchers.anyString())).thenReturn((Object)true);
            DockerEnvironmentFactory factory = this.getFactory((workerId, timeout) -> this.client);
            RunnerApi.Environment fooEnv = Environments.createDockerEnvironment((String)"foo");
            RemoteEnvironment fooHandle = factory.createEnvironment(fooEnv);
            Assert.assertThat((Object)fooHandle.getEnvironment(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooEnv)));
            RunnerApi.Environment barEnv = Environments.createDockerEnvironment((String)"bar");
            RemoteEnvironment barHandle = factory.createEnvironment(barEnv);
            Assert.assertThat((Object)barHandle.getEnvironment(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)barEnv)));
        }

        private DockerEnvironmentFactory getFactory(ControlClientPool.Source clientSource) {
            return DockerEnvironmentFactory.forServicesWithDocker((DockerCommand)this.docker, (GrpcFnServer)this.controlServiceServer, (GrpcFnServer)this.loggingServiceServer, (GrpcFnServer)this.retrievalServiceServer, (GrpcFnServer)this.provisioningServiceServer, (ControlClientPool.Source)clientSource, (IdGenerator)ID_GENERATOR, (boolean)false);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ParameterizedTest
    extends DockerEnvironmentFactoryTest {
        @Parameterized.Parameter(value=0)
        public boolean throwsException;
        @Parameterized.Parameter(value=1)
        public boolean retainDockerContainer;
        @Parameterized.Parameter(value=2)
        public int removeContainerTimes;
        @Rule
        public ExpectedException expectedException = ExpectedException.none();
        private final ControlClientPool.Source normalClientSource = (workerId, timeout) -> this.client;
        private final ControlClientPool.Source exceptionClientSource = (workerId, timeout) -> {
            throw new Exception();
        };

        @Parameterized.Parameters(name="{index}: Test with throwsException={0}, retainDockerContainer={1} should remove container {2} time(s)")
        public static Collection<Object[]> data() {
            Object[][] data = new Object[][]{{false, false, 1}, {false, true, 0}, {true, false, 1}, {true, true, 0}};
            return Arrays.asList(data);
        }

        @Test
        public void cleansUpContainerCorrectly() throws Exception {
            Mockito.when((Object)this.docker.runImage((String)Mockito.eq((Object)DockerEnvironmentFactoryTest.IMAGE_NAME), (List)Mockito.any(), (List)Mockito.any())).thenReturn((Object)DockerEnvironmentFactoryTest.CONTAINER_ID);
            Mockito.when((Object)this.docker.isContainerRunning((String)Mockito.eq((Object)DockerEnvironmentFactoryTest.CONTAINER_ID))).thenReturn((Object)true);
            DockerEnvironmentFactory factory = DockerEnvironmentFactory.forServicesWithDocker((DockerCommand)this.docker, (GrpcFnServer)this.controlServiceServer, (GrpcFnServer)this.loggingServiceServer, (GrpcFnServer)this.retrievalServiceServer, (GrpcFnServer)this.provisioningServiceServer, (ControlClientPool.Source)(this.throwsException ? this.exceptionClientSource : this.normalClientSource), (IdGenerator)ID_GENERATOR, (boolean)this.retainDockerContainer);
            if (this.throwsException) {
                this.expectedException.expect(Exception.class);
            }
            RemoteEnvironment handle = factory.createEnvironment(ENVIRONMENT);
            handle.close();
            ((DockerCommand)Mockito.verify((Object)this.docker)).killContainer(DockerEnvironmentFactoryTest.CONTAINER_ID);
            ((DockerCommand)Mockito.verify((Object)this.docker, (VerificationMode)Mockito.times((int)this.removeContainerTimes))).removeContainer(DockerEnvironmentFactoryTest.CONTAINER_ID);
        }
    }
}

