/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.control;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import org.apache.beam.runners.fnexecution.control.ExecutableStageContext;
import org.apache.beam.runners.fnexecution.control.ReferenceCountingExecutableStageContextFactory;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Charsets;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class ReferenceCountingExecutableStageContextFactoryTest {
    @Test
    public void testCreateReuseReleaseCreate() throws Exception {
        ReferenceCountingExecutableStageContextFactory.Creator creator = (ReferenceCountingExecutableStageContextFactory.Creator)Mockito.mock(ReferenceCountingExecutableStageContextFactory.Creator.class);
        ExecutableStageContext c1 = (ExecutableStageContext)Mockito.mock(ExecutableStageContext.class);
        ExecutableStageContext c2 = (ExecutableStageContext)Mockito.mock(ExecutableStageContext.class);
        ExecutableStageContext c3 = (ExecutableStageContext)Mockito.mock(ExecutableStageContext.class);
        ExecutableStageContext c4 = (ExecutableStageContext)Mockito.mock(ExecutableStageContext.class);
        Mockito.when((Object)((ExecutableStageContext)creator.apply((Object)((JobInfo)Matchers.any(JobInfo.class))))).thenReturn((Object)c1).thenReturn((Object)c2).thenReturn((Object)c3).thenReturn((Object)c4);
        ReferenceCountingExecutableStageContextFactory factory = ReferenceCountingExecutableStageContextFactory.create((ReferenceCountingExecutableStageContextFactory.Creator)creator, (SerializableFunction & Serializable)x -> true);
        JobInfo jobA = (JobInfo)Mockito.mock(JobInfo.class);
        Mockito.when((Object)jobA.jobId()).thenReturn((Object)"jobA");
        JobInfo jobB = (JobInfo)Mockito.mock(JobInfo.class);
        Mockito.when((Object)jobB.jobId()).thenReturn((Object)"jobB");
        ExecutableStageContext ac1A = factory.get(jobA);
        ExecutableStageContext ac2B = factory.get(jobB);
        Assert.assertSame((String)"Context should be cached and reused.", (Object)ac1A, (Object)factory.get(jobA));
        Assert.assertSame((String)"Context should be cached and reused.", (Object)ac2B, (Object)factory.get(jobB));
        factory.release(ac1A);
        Assert.assertSame((String)"Context should be cached and reused.", (Object)ac1A, (Object)factory.get(jobA));
        factory.release(ac1A);
        factory.release(ac1A);
        ExecutableStageContext ac3A = factory.get(jobA);
        Assert.assertNotSame((String)"We should get a new instance.", (Object)ac1A, (Object)ac3A);
        Assert.assertSame((String)"Context should be cached and reused.", (Object)ac3A, (Object)factory.get(jobA));
        factory.release(ac3A);
        factory.release(ac3A);
        Assert.assertSame((String)"Context should be cached and reused.", (Object)ac2B, (Object)factory.get(jobB));
        factory.release(ac2B);
        factory.release(ac2B);
        factory.release(ac2B);
        ExecutableStageContext ac4B = factory.get(jobB);
        Assert.assertNotSame((String)"We should get a new instance.", (Object)ac2B, (Object)ac4B);
        factory.release(ac4B);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCatchThrowablesAndLogThem() throws Exception {
        PrintStream oldErr = System.err;
        oldErr.flush();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream newErr = new PrintStream(baos);
        try {
            System.setErr(newErr);
            ReferenceCountingExecutableStageContextFactory.Creator creator = (ReferenceCountingExecutableStageContextFactory.Creator)Mockito.mock(ReferenceCountingExecutableStageContextFactory.Creator.class);
            ExecutableStageContext c1 = (ExecutableStageContext)Mockito.mock(ExecutableStageContext.class);
            Mockito.when((Object)((ExecutableStageContext)creator.apply((Object)((JobInfo)Matchers.any(JobInfo.class))))).thenReturn((Object)c1);
            ((ExecutableStageContext)Mockito.doThrow((Throwable[])new Throwable[]{new NoClassDefFoundError()}).when((Object)c1)).close();
            ReferenceCountingExecutableStageContextFactory factory = ReferenceCountingExecutableStageContextFactory.create((ReferenceCountingExecutableStageContextFactory.Creator)creator, (SerializableFunction & Serializable)x -> true);
            JobInfo jobA = (JobInfo)Mockito.mock(JobInfo.class);
            Mockito.when((Object)jobA.jobId()).thenReturn((Object)"jobA");
            ExecutableStageContext ac1A = factory.get(jobA);
            factory.release(ac1A);
            newErr.flush();
            String output = new String(baos.toByteArray(), Charsets.UTF_8);
            Assert.assertTrue((boolean)output.contains("Unable to close ExecutableStageContext"));
        }
        finally {
            newErr.flush();
            System.setErr(oldErr);
        }
    }
}

