/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.control;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.runners.fnexecution.control.FnApiControlClient;
import org.apache.beam.sdk.util.MoreFutures;
import org.apache.beam.vendor.grpc.v1p21p0.io.grpc.stub.StreamObserver;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class FnApiControlClientTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Mock
    public StreamObserver<BeamFnApi.InstructionRequest> mockObserver;
    private FnApiControlClient client;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.client = FnApiControlClient.forRequestObserver((String)"DUMMY", this.mockObserver);
    }

    @Test
    public void testRequestSent() {
        String id = "instructionId";
        this.client.handle(BeamFnApi.InstructionRequest.newBuilder().setInstructionId(id).build());
        ((StreamObserver)Mockito.verify(this.mockObserver)).onNext((Object)((BeamFnApi.InstructionRequest)org.mockito.Matchers.any(BeamFnApi.InstructionRequest.class)));
    }

    @Test
    public void testRequestSuccess() throws Exception {
        String id = "successfulInstruction";
        CompletionStage responseFuture = this.client.handle(BeamFnApi.InstructionRequest.newBuilder().setInstructionId(id).build());
        this.client.asResponseObserver().onNext((Object)BeamFnApi.InstructionResponse.newBuilder().setInstructionId(id).build());
        BeamFnApi.InstructionResponse response = (BeamFnApi.InstructionResponse)MoreFutures.get((CompletionStage)responseFuture);
        Assert.assertThat((Object)response.getInstructionId(), (Matcher)Matchers.equalTo((Object)id));
    }

    @Test
    public void testRequestError() throws Exception {
        String id = "instructionId";
        CompletionStage responseFuture = this.client.handle(BeamFnApi.InstructionRequest.newBuilder().setInstructionId(id).build());
        String error = "Oh no an error!";
        this.client.asResponseObserver().onNext((Object)BeamFnApi.InstructionResponse.newBuilder().setInstructionId(id).setError(error).build());
        this.thrown.expectCause(Matchers.isA(RuntimeException.class));
        this.thrown.expectMessage(error);
        MoreFutures.get((CompletionStage)responseFuture);
    }

    @Test
    public void testUnknownResponseIgnored() throws Exception {
        String id = "actualInstruction";
        String unknownId = "unknownInstruction";
        CompletionStage responseFuture = this.client.handle(BeamFnApi.InstructionRequest.newBuilder().setInstructionId(id).build());
        this.client.asResponseObserver().onNext((Object)BeamFnApi.InstructionResponse.newBuilder().setInstructionId(unknownId).build());
        Assert.assertThat((Object)MoreFutures.isDone((CompletionStage)responseFuture), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)MoreFutures.isCancelled((CompletionStage)responseFuture), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testOnCompletedCancelsOutstanding() throws Exception {
        String id = "clientHangUpInstruction";
        CompletionStage responseFuture = this.client.handle(BeamFnApi.InstructionRequest.newBuilder().setInstructionId(id).build());
        this.client.asResponseObserver().onCompleted();
        this.thrown.expect(ExecutionException.class);
        this.thrown.expectCause(Matchers.isA(IllegalStateException.class));
        this.thrown.expectMessage("closed");
        MoreFutures.get((CompletionStage)responseFuture);
    }

    @Test
    public void testOnErrorCancelsOutstanding() throws Exception {
        String id = "errorInstruction";
        CompletionStage responseFuture = this.client.handle(BeamFnApi.InstructionRequest.newBuilder().setInstructionId(id).build());
        class FrazzleException
        extends Exception {
            FrazzleException() {
            }
        }
        this.client.asResponseObserver().onError((Throwable)new FrazzleException());
        this.thrown.expect(ExecutionException.class);
        this.thrown.expectCause(Matchers.isA(FrazzleException.class));
        MoreFutures.get((CompletionStage)responseFuture);
    }

    @Test
    public void testCloseCancelsOutstanding() throws Exception {
        String id = "serverCloseInstruction";
        CompletionStage responseFuture = this.client.handle(BeamFnApi.InstructionRequest.newBuilder().setInstructionId(id).build());
        this.client.close();
        this.thrown.expect(ExecutionException.class);
        this.thrown.expectCause(Matchers.isA(IllegalStateException.class));
        this.thrown.expectMessage("closed");
        MoreFutures.get((CompletionStage)responseFuture);
    }

    @Test
    public void testOnCloseMultipleListener() throws Exception {
        Consumer mockConsumer1 = (Consumer)Mockito.mock(Consumer.class);
        Consumer mockConsumer2 = (Consumer)Mockito.mock(Consumer.class);
        this.client.onClose(mockConsumer1);
        this.client.onClose(mockConsumer2);
        this.client.close();
        ((Consumer)Mockito.verify((Object)mockConsumer1)).accept(this.client);
        ((Consumer)Mockito.verify((Object)mockConsumer2)).accept(this.client);
    }
}

