/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.control;

import java.io.Serializable;
import org.apache.beam.runners.fnexecution.control.DefaultExecutableStageContext;
import org.apache.beam.runners.fnexecution.control.ReferenceCountingExecutableStageContextFactory;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.Struct;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DefaultExecutableStageContextTest {
    @Test
    public void testMultiInstanceFactory() {
        JobInfo jobInfo = JobInfo.create((String)"multi-instance-factory-test", (String)"job-name", (String)"retrieval-token", (Struct)Struct.getDefaultInstance());
        DefaultExecutableStageContext.MultiInstanceFactory multiInstanceFactory = new DefaultExecutableStageContext.MultiInstanceFactory(2, (SerializableFunction & Serializable)x -> true);
        ReferenceCountingExecutableStageContextFactory.WrappedContext f1 = (ReferenceCountingExecutableStageContextFactory.WrappedContext)multiInstanceFactory.get(jobInfo);
        ReferenceCountingExecutableStageContextFactory.WrappedContext f2 = (ReferenceCountingExecutableStageContextFactory.WrappedContext)multiInstanceFactory.get(jobInfo);
        ReferenceCountingExecutableStageContextFactory.WrappedContext f3 = (ReferenceCountingExecutableStageContextFactory.WrappedContext)multiInstanceFactory.get(jobInfo);
        Assert.assertNotEquals((String)"We should create two different factories", (Object)f1.context, (Object)f2.context);
        Assert.assertEquals((String)"Future calls should be round-robbined to those two factories", (Object)f1.context, (Object)f3.context);
    }

    @Test
    public void testDefault() {
        JobInfo jobInfo = JobInfo.create((String)"default-test", (String)"job-name", (String)"retrieval-token", (Struct)Struct.getDefaultInstance());
        DefaultExecutableStageContext.MultiInstanceFactory multiInstanceFactory = new DefaultExecutableStageContext.MultiInstanceFactory(0, (SerializableFunction & Serializable)x -> true);
        int expectedParallelism = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        ReferenceCountingExecutableStageContextFactory.WrappedContext f1 = (ReferenceCountingExecutableStageContextFactory.WrappedContext)multiInstanceFactory.get(jobInfo);
        for (int i = 1; i < expectedParallelism; ++i) {
            Assert.assertNotEquals((String)("We should create " + expectedParallelism + " different factories"), (Object)f1.context, (Object)((ReferenceCountingExecutableStageContextFactory.WrappedContext)multiInstanceFactory.get((JobInfo)jobInfo)).context);
        }
        Assert.assertEquals((String)"Future calls should be round-robbined to those", (Object)f1.context, (Object)((ReferenceCountingExecutableStageContextFactory.WrappedContext)multiInstanceFactory.get((JobInfo)jobInfo)).context);
    }
}

