/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import java.nio.ByteBuffer;
import org.apache.beam.runners.core.KeyedWorkItem;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.translation.types.CoderTypeInformation;
import org.apache.beam.runners.flink.translation.wrappers.streaming.FlinkKeyUtils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class WorkItemKeySelector<@UnknownKeyFor K, @UnknownKeyFor V>
implements KeySelector<WindowedValue<KeyedWorkItem<K, V>>, ByteBuffer>,
ResultTypeQueryable<ByteBuffer> {
    private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
    private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions pipelineOptions;

    public WorkItemKeySelector(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions pipelineOptions) {
        this.keyCoder = keyCoder;
        this.pipelineOptions = pipelineOptions;
    }

    public @UnknownKeyFor @NonNull @Initialized ByteBuffer getKey(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, V>> value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Object key = ((KeyedWorkItem)value.getValue()).key();
        return FlinkKeyUtils.encodeKey(key, this.keyCoder);
    }

    public @UnknownKeyFor @NonNull @Initialized TypeInformation<@UnknownKeyFor @NonNull @Initialized ByteBuffer> getProducedType() {
        return new CoderTypeInformation<ByteBuffer>((Coder<ByteBuffer>)FlinkKeyUtils.ByteBufferCoder.of(), this.pipelineOptions.get());
    }
}

