/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.utils;

import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.InvalidProtocolBufferException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FlinkPortableRunnerUtils {
    public static @UnknownKeyFor @NonNull @Initialized boolean requiresTimeSortedInput(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload payload, @UnknownKeyFor @NonNull @Initialized boolean streaming) {
        boolean requiresTimeSortedInput = payload.getComponents().getTransformsMap().values().stream().filter(t -> t.getSpec().getUrn().equals("beam:transform:pardo:v1")).anyMatch(t -> {
            try {
                return RunnerApi.ParDoPayload.parseFrom((ByteString)t.getSpec().getPayload()).getRequiresTimeSortedInput();
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        });
        if (streaming && requiresTimeSortedInput) {
            throw new UnsupportedOperationException("https://issues.apache.org/jira/browse/BEAM-8460 blocks this feature for now.");
        }
        return requiresTimeSortedInput;
    }

    private FlinkPortableRunnerUtils() {
    }
}

