/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.util.Map;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.translation.functions.AbstractFlinkCombineRunner;
import org.apache.beam.runners.flink.translation.functions.FlinkSideInputReader;
import org.apache.beam.runners.flink.translation.functions.HashingFlinkCombineRunner;
import org.apache.beam.runners.flink.translation.functions.SortingFlinkCombineRunner;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FlinkMergingNonShuffleReduceFunction<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
extends RichGroupReduceFunction<WindowedValue<KV<K, InputT>>, WindowedValue<KV<K, OutputT>>> {
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> combineFn;
    private final @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @NonNull @Initialized Object, W> windowingStrategy;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> sideInputs;
    private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions serializedOptions;

    public FlinkMergingNonShuffleReduceFunction(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> combineFn, @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @NonNull @Initialized Object, W> windowingStrategy, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> sideInputs, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        this.combineFn = combineFn;
        this.windowingStrategy = windowingStrategy;
        this.sideInputs = sideInputs;
        this.serializedOptions = new SerializablePipelineOptions(pipelineOptions);
    }

    public void open(@UnknownKeyFor @NonNull @Initialized Configuration parameters) {
        FileSystems.setDefaultPipelineOptions((PipelineOptions)this.serializedOptions.get());
    }

    public void reduce(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>> elements, @UnknownKeyFor @NonNull @Initialized Collector<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>>> out) throws @UnknownKeyFor @NonNull @Initialized Exception {
        PipelineOptions options = this.serializedOptions.get();
        FlinkSideInputReader sideInputReader = new FlinkSideInputReader(this.sideInputs, this.getRuntimeContext());
        AbstractFlinkCombineRunner reduceRunner = this.windowingStrategy.getWindowFn().windowCoder().equals(IntervalWindow.getCoder()) ? new SortingFlinkCombineRunner() : new HashingFlinkCombineRunner();
        reduceRunner.combine(new AbstractFlinkCombineRunner.CompleteFlinkCombiner(this.combineFn), this.windowingStrategy, sideInputReader, options, elements, out);
    }
}

