/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.website;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.CaseFormat;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PipelineOptionsTableGenerator {
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> supportedLanguages = ImmutableList.of((Object)"java", (Object)"python");

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        if (args.length != 1) {
            throw new RuntimeException("Please specify the language (" + supportedLanguages + ") as the only argument.");
        }
        String arg = args[0].toLowerCase();
        if (!supportedLanguages.contains(arg)) {
            throw new RuntimeException("The language is not supported: " + arg);
        }
        boolean isPython = arg.equals("python");
        PipelineOptionsTableGenerator.printHeader();
        List<Option> options = PipelineOptionsTableGenerator.extractOptions(isPython);
        PipelineOptionsTableGenerator.printOptionsTable(options);
    }

    private static void printHeader() {
        System.out.println("<!--\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\nhttp://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n-->");
        System.out.println("<!--\nThis is an auto-generated file.\nUse generatePipelineOptionsTableJava and generatePipelineOptionsTablePython respectively.\nShould be called before running the tests.\n-->");
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Option> extractOptions(@UnknownKeyFor @NonNull @Initialized boolean isPython) {
        ArrayList<Option> options = new ArrayList<Option>();
        for (Method method : FlinkPipelineOptions.class.getDeclaredMethods()) {
            String defaultValue = null;
            String name = method.getName();
            if (!name.matches("^(get|is).*")) continue;
            name = name.replaceFirst("^(get|is)", "");
            name = isPython ? CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name) : Character.toLowerCase(name.charAt(0)) + name.substring(1);
            Description descriptionAnnotation = method.getAnnotation(Description.class);
            if (descriptionAnnotation == null) {
                throw new RuntimeException("All pipeline options should have a description. Please add one for " + name);
            }
            String description = descriptionAnnotation.value();
            Optional<String> defaultValueFromAnnotation = PipelineOptionsTableGenerator.getDefaultValueFromAnnotation(method);
            if (defaultValueFromAnnotation.isPresent()) {
                defaultValue = defaultValueFromAnnotation.get();
            }
            options.add(new Option(name, description, defaultValue));
        }
        options.sort(Comparator.comparing(option -> option.name));
        return options;
    }

    private static void printOptionsTable(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Option> options) {
        System.out.println("<table class=\"table table-bordered\">");
        for (Option option : options) {
            System.out.println("<tr>");
            System.out.println("  <td><code>" + option.name + "</code></td>");
            System.out.println("  <td>" + option.description + "</td>");
            if (option.defaultValue != null) {
                System.out.println("  <td>Default: <code>" + option.defaultValue + "</code></td>");
            } else {
                System.out.println("  <td></td>");
            }
            System.out.println("</tr>");
        }
        System.out.println("</table>");
    }

    private static @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> getDefaultValueFromAnnotation(@UnknownKeyFor @NonNull @Initialized Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (annotation instanceof Default.Class) {
                return Optional.of(((Default.Class)annotation).value().getSimpleName());
            }
            if (annotation instanceof Default.String) {
                return Optional.of(((Default.String)annotation).value());
            }
            if (annotation instanceof Default.Boolean) {
                return Optional.of(Boolean.toString(((Default.Boolean)annotation).value()));
            }
            if (annotation instanceof Default.Character) {
                return Optional.of(Character.toString(((Default.Character)annotation).value()));
            }
            if (annotation instanceof Default.Byte) {
                return Optional.of(Byte.toString(((Default.Byte)annotation).value()));
            }
            if (annotation instanceof Default.Short) {
                return Optional.of(Short.toString(((Default.Short)annotation).value()));
            }
            if (annotation instanceof Default.Integer) {
                return Optional.of(Integer.toString(((Default.Integer)annotation).value()));
            }
            if (annotation instanceof Default.Long) {
                return Optional.of(Long.toString(((Default.Long)annotation).value()));
            }
            if (annotation instanceof Default.Float) {
                return Optional.of(Float.toString(((Default.Float)annotation).value()));
            }
            if (annotation instanceof Default.Double) {
                return Optional.of(Double.toString(((Default.Double)annotation).value()));
            }
            if (annotation instanceof Default.Enum) {
                return Optional.of(((Default.Enum)annotation).value());
            }
            if (!(annotation instanceof Default.InstanceFactory)) continue;
            return Optional.of(((Default.InstanceFactory)annotation).value().getSimpleName());
        }
        return Optional.empty();
    }

    private static class Option {
        @UnknownKeyFor @NonNull @Initialized String name;
        @UnknownKeyFor @NonNull @Initialized String description;
        @Nullable @UnknownKeyFor @Initialized String defaultValue;

        public Option(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String description, @Nullable @UnknownKeyFor @Initialized String defaultValue) {
            this.name = name;
            this.description = description;
            this.defaultValue = defaultValue;
        }
    }
}

