/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput;

import java.util.Collections;
import java.util.List;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.BufferingDoFnRunner;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class BufferingDoFnRunnerTest {
    @Test
    public void testRestoreWithoutConcurrentCheckpoints() throws @UnknownKeyFor @NonNull @Initialized Exception {
        BufferingDoFnRunner bufferingDoFnRunner = BufferingDoFnRunnerTest.createBufferingDoFnRunner(1, Collections.emptyList());
        MatcherAssert.assertThat((Object)bufferingDoFnRunner.currentStateIndex, (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)bufferingDoFnRunner.numCheckpointBuffers, (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testRestoreWithoutConcurrentCheckpointsWithPendingCheckpoint() throws @UnknownKeyFor @NonNull @Initialized Exception {
        BufferingDoFnRunner bufferingDoFnRunner = BufferingDoFnRunnerTest.createBufferingDoFnRunner(1, Collections.singletonList(new BufferingDoFnRunner.CheckpointIdentifier(0, 1000L)));
        MatcherAssert.assertThat((Object)bufferingDoFnRunner.currentStateIndex, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)bufferingDoFnRunner.numCheckpointBuffers, (Matcher)Matchers.is((Object)2));
        bufferingDoFnRunner = BufferingDoFnRunnerTest.createBufferingDoFnRunner(1, Collections.singletonList(new BufferingDoFnRunner.CheckpointIdentifier(1, 1000L)));
        MatcherAssert.assertThat((Object)bufferingDoFnRunner.currentStateIndex, (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)bufferingDoFnRunner.numCheckpointBuffers, (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testRestoreWithoutConcurrentCheckpointsWithPendingCheckpointFromConcurrentCheckpointing() throws @UnknownKeyFor @NonNull @Initialized Exception {
        BufferingDoFnRunner bufferingDoFnRunner = BufferingDoFnRunnerTest.createBufferingDoFnRunner(1, Collections.singletonList(new BufferingDoFnRunner.CheckpointIdentifier(5, 42L)));
        MatcherAssert.assertThat((Object)bufferingDoFnRunner.currentStateIndex, (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)bufferingDoFnRunner.numCheckpointBuffers, (Matcher)Matchers.is((Object)6));
    }

    @Test
    public void testRestoreWithConcurrentCheckpoints() throws @UnknownKeyFor @NonNull @Initialized Exception {
        BufferingDoFnRunner bufferingDoFnRunner = BufferingDoFnRunnerTest.createBufferingDoFnRunner(2, Collections.emptyList());
        MatcherAssert.assertThat((Object)bufferingDoFnRunner.currentStateIndex, (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)bufferingDoFnRunner.numCheckpointBuffers, (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testRestoreWithConcurrentCheckpointsFromPendingCheckpoint() throws @UnknownKeyFor @NonNull @Initialized Exception {
        BufferingDoFnRunner bufferingDoFnRunner = BufferingDoFnRunnerTest.createBufferingDoFnRunner(2, Collections.singletonList(new BufferingDoFnRunner.CheckpointIdentifier(0, 1000L)));
        MatcherAssert.assertThat((Object)bufferingDoFnRunner.currentStateIndex, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)bufferingDoFnRunner.numCheckpointBuffers, (Matcher)Matchers.is((Object)3));
        bufferingDoFnRunner = BufferingDoFnRunnerTest.createBufferingDoFnRunner(2, Collections.singletonList(new BufferingDoFnRunner.CheckpointIdentifier(2, 1000L)));
        MatcherAssert.assertThat((Object)bufferingDoFnRunner.currentStateIndex, (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)bufferingDoFnRunner.numCheckpointBuffers, (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testRestoreWithConcurrentCheckpointsFromPendingCheckpoints() throws @UnknownKeyFor @NonNull @Initialized Exception {
        BufferingDoFnRunner bufferingDoFnRunner = BufferingDoFnRunnerTest.createBufferingDoFnRunner(3, (List<BufferingDoFnRunner.CheckpointIdentifier>)ImmutableList.of((Object)new BufferingDoFnRunner.CheckpointIdentifier(0, 42L), (Object)new BufferingDoFnRunner.CheckpointIdentifier(1, 43L)));
        MatcherAssert.assertThat((Object)bufferingDoFnRunner.currentStateIndex, (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)bufferingDoFnRunner.numCheckpointBuffers, (Matcher)Matchers.is((Object)4));
        bufferingDoFnRunner = BufferingDoFnRunnerTest.createBufferingDoFnRunner(3, (List<BufferingDoFnRunner.CheckpointIdentifier>)ImmutableList.of((Object)new BufferingDoFnRunner.CheckpointIdentifier(2, 42L), (Object)new BufferingDoFnRunner.CheckpointIdentifier(3, 43L)));
        MatcherAssert.assertThat((Object)bufferingDoFnRunner.currentStateIndex, (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)bufferingDoFnRunner.numCheckpointBuffers, (Matcher)Matchers.is((Object)4));
    }

    @Test
    public void testRejectConcurrentCheckpointingBoundaries() {
        Assert.assertThrows(IllegalArgumentException.class, () -> BufferingDoFnRunnerTest.createBufferingDoFnRunner(0, Collections.emptyList()));
        Assert.assertThrows(IllegalArgumentException.class, () -> BufferingDoFnRunnerTest.createBufferingDoFnRunner(Short.MAX_VALUE, Collections.emptyList()));
    }

    private static @UnknownKeyFor @NonNull @Initialized BufferingDoFnRunner createBufferingDoFnRunner(@UnknownKeyFor @NonNull @Initialized int concurrentCheckpoints, @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BufferingDoFnRunner.CheckpointIdentifier> notYetAcknowledgeCheckpoints) throws @UnknownKeyFor @NonNull @Initialized Exception {
        DoFnRunner doFnRunner = (DoFnRunner)Mockito.mock(DoFnRunner.class);
        OperatorStateBackend operatorStateBackend = (OperatorStateBackend)Mockito.mock(OperatorStateBackend.class);
        ListState unionListState = (ListState)Mockito.mock(ListState.class);
        Mockito.when((Object)operatorStateBackend.getUnionListState((ListStateDescriptor)Mockito.any())).thenReturn((Object)unionListState);
        Mockito.when((Object)unionListState.get()).thenReturn(notYetAcknowledgeCheckpoints);
        Mockito.when((Object)operatorStateBackend.getListState((ListStateDescriptor)Mockito.any())).thenReturn((Object)((ListState)Mockito.mock(ListState.class)));
        return BufferingDoFnRunner.create((DoFnRunner)doFnRunner, (String)"stable-input", (Coder)StringUtf8Coder.of(), (Coder)WindowedValue.getFullCoder((Coder)VarIntCoder.of(), (Coder)GlobalWindow.Coder.INSTANCE), (OperatorStateBackend)operatorStateBackend, null, (int)concurrentCheckpoints, (SerializablePipelineOptions)new SerializablePipelineOptions((PipelineOptions)FlinkPipelineOptions.defaults()));
    }
}

