/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.BufferedElement;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.BufferedElements;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.Instant;
import org.junit.Test;

public class BufferedElementsTest {
    @Test
    public void testCoder() throws @UnknownKeyFor @NonNull @Initialized IOException {
        StringUtf8Coder elementCoder = StringUtf8Coder.of();
        GlobalWindow.Coder windowCoder = GlobalWindow.Coder.INSTANCE;
        WindowedValue.FullWindowedValueCoder windowedValueCoder = WindowedValue.FullWindowedValueCoder.of((Coder)elementCoder, (Coder)windowCoder);
        KV key = KV.of((Object)"one", (Object)1);
        BufferedElements.Coder coder = new BufferedElements.Coder((Coder)windowedValueCoder, (Coder)windowCoder, (Object)key);
        BufferedElements.Element element = new BufferedElements.Element(WindowedValue.of((Object)"test", (Instant)new Instant(2L), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.NO_FIRING));
        BufferedElements.Timer timerElement = new BufferedElements.Timer("timerId", "timerId", (Object)key, (BoundedWindow)GlobalWindow.INSTANCE, new Instant(1L), new Instant(1L), TimeDomain.EVENT_TIME);
        BufferedElementsTest.testRoundTrip((List<BufferedElement>)ImmutableList.of((Object)element), coder);
        BufferedElementsTest.testRoundTrip((List<BufferedElement>)ImmutableList.of((Object)timerElement), coder);
        BufferedElementsTest.testRoundTrip((List<BufferedElement>)ImmutableList.of((Object)element, (Object)timerElement), coder);
        BufferedElementsTest.testRoundTrip((List<BufferedElement>)ImmutableList.of((Object)element, (Object)timerElement, (Object)element), coder);
        BufferedElementsTest.testRoundTrip((List<BufferedElement>)ImmutableList.of((Object)element, (Object)element, (Object)element, (Object)timerElement, (Object)timerElement), coder);
    }

    private static void testRoundTrip(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BufferedElement> bufferedElements, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BufferedElements.Coder coder) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (BufferedElement bufferedElement : bufferedElements) {
            coder.encode(bufferedElement, (OutputStream)baos);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        for (BufferedElement bufferedElement : bufferedElements) {
            MatcherAssert.assertThat((Object)coder.decode((InputStream)bais), (Matcher)Matchers.is((Object)bufferedElement));
        }
    }
}

