/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import java.nio.ByteBuffer;
import org.apache.beam.runners.flink.translation.wrappers.streaming.FlinkKeyUtils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Charsets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;

public class FlinkKeyUtilsTest {
    @Test
    public void testEncodeDecode() {
        String key = "key";
        StringUtf8Coder coder = StringUtf8Coder.of();
        ByteBuffer byteBuffer = FlinkKeyUtils.encodeKey((Object)key, (Coder)coder);
        MatcherAssert.assertThat((Object)((String)FlinkKeyUtils.decodeKey((ByteBuffer)byteBuffer, (Coder)coder)), (Matcher)Is.is((Object)key));
    }

    @Test
    public void testNullKey() {
        Object key = null;
        VoidCoder coder = VoidCoder.of();
        ByteBuffer byteBuffer = FlinkKeyUtils.encodeKey(key, (Coder)coder);
        MatcherAssert.assertThat((Object)((Void)FlinkKeyUtils.decodeKey((ByteBuffer)byteBuffer, (Coder)coder)), (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testCoderContext() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String input = "hello world";
        StringUtf8Coder coder = StringUtf8Coder.of();
        ByteBuffer encoded = FlinkKeyUtils.encodeKey((Object)input, (Coder)coder);
        MatcherAssert.assertThat((Object)encoded.array(), (Matcher)Is.is((Object)CoderUtils.encodeToByteArray((Coder)coder, (Object)input, (Coder.Context)Coder.Context.NESTED)));
    }

    @Test
    public void testFromEncodedKey() {
        ByteString input = ByteString.copyFrom((byte[])"hello world".getBytes(Charsets.UTF_8));
        ByteBuffer encodedKey = FlinkKeyUtils.fromEncodedKey((ByteString)input);
        MatcherAssert.assertThat((Object)encodedKey.array(), (Matcher)Is.is((Object)input.toByteArray()));
    }
}

