/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.beam.runners.flink.translation.wrappers.streaming.StreamRecordStripper;
import org.apache.beam.runners.flink.translation.wrappers.streaming.io.DedupingOperator;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.ValueWithRecordId;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DedupingOperatorTest {
    @Test
    public void testDeduping() throws @UnknownKeyFor @NonNull @Initialized Exception {
        KeyedOneInputStreamOperatorTestHarness<ByteBuffer, WindowedValue<ValueWithRecordId<String>>, WindowedValue<String>> harness = this.getDebupingHarness();
        harness.open();
        String key1 = "key1";
        String key2 = "key2";
        harness.processElement(new StreamRecord((Object)WindowedValue.valueInGlobalWindow((Object)new ValueWithRecordId((Object)key1, key1.getBytes(StandardCharsets.UTF_8)))));
        harness.processElement(new StreamRecord((Object)WindowedValue.valueInGlobalWindow((Object)new ValueWithRecordId((Object)key2, key2.getBytes(StandardCharsets.UTF_8)))));
        harness.processElement(new StreamRecord((Object)WindowedValue.valueInGlobalWindow((Object)new ValueWithRecordId((Object)key1, key1.getBytes(StandardCharsets.UTF_8)))));
        Assert.assertThat(StreamRecordStripper.stripStreamRecordFromWindowedValue(harness.getOutput()), (Matcher)IsIterableContainingInOrder.contains((Object[])new WindowedValue[]{WindowedValue.valueInGlobalWindow((Object)key1), WindowedValue.valueInGlobalWindow((Object)key2)}));
        OperatorSubtaskState snapshot = harness.snapshot(0L, 0L);
        harness.close();
        harness = this.getDebupingHarness();
        harness.setup();
        harness.initializeState(snapshot);
        harness.open();
        String key3 = "key3";
        harness.processElement(new StreamRecord((Object)WindowedValue.valueInGlobalWindow((Object)new ValueWithRecordId((Object)key2, key2.getBytes(StandardCharsets.UTF_8)))));
        harness.processElement(new StreamRecord((Object)WindowedValue.valueInGlobalWindow((Object)new ValueWithRecordId((Object)key3, key3.getBytes(StandardCharsets.UTF_8)))));
        Assert.assertThat(StreamRecordStripper.stripStreamRecordFromWindowedValue(harness.getOutput()), (Matcher)IsIterableContainingInOrder.contains((Object[])new WindowedValue[]{WindowedValue.valueInGlobalWindow((Object)key3)}));
        harness.close();
    }

    private @UnknownKeyFor @NonNull @Initialized KeyedOneInputStreamOperatorTestHarness<@UnknownKeyFor @NonNull @Initialized ByteBuffer, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ValueWithRecordId<@UnknownKeyFor @NonNull @Initialized String>>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized String>> getDebupingHarness() throws @UnknownKeyFor @NonNull @Initialized Exception {
        DedupingOperator operator = new DedupingOperator(PipelineOptionsFactory.create());
        return new KeyedOneInputStreamOperatorTestHarness((OneInputStreamOperator)operator, (KeySelector & Serializable)value -> ByteBuffer.wrap(((ValueWithRecordId)value.getValue()).getId()), TypeInformation.of(ByteBuffer.class));
    }
}

