/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.util.Collections;
import java.util.Map;
import org.apache.beam.runners.flink.metrics.FlinkMetricContainer;
import org.apache.beam.runners.flink.translation.functions.FlinkStatefulDoFnFunction;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Test;
import org.mockito.Mockito;
import org.powermock.reflect.Whitebox;

public class FlinkStatefulDoFnFunctionTest {
    @Test
    public void testAccumulatorRegistrationOnOperatorClose() throws @UnknownKeyFor @NonNull @Initialized Exception {
        TestDoFnFunction doFnFunction = new TestDoFnFunction("step", WindowingStrategy.globalDefault(), Collections.emptyMap(), PipelineOptionsFactory.create(), Collections.emptyMap(), new TupleTag(), null, Collections.emptyMap(), DoFnSchemaInformation.create(), Collections.emptyMap());
        doFnFunction.open(new Configuration());
        String metricContainerFieldName = "metricContainer";
        FlinkMetricContainer monitoredContainer = (FlinkMetricContainer)Mockito.spy((Object)((FlinkMetricContainer)Whitebox.getInternalState((Object)((Object)doFnFunction), (String)metricContainerFieldName)));
        Whitebox.setInternalState((Object)((Object)doFnFunction), (String)metricContainerFieldName, (Object)monitoredContainer);
        doFnFunction.close();
        ((FlinkMetricContainer)Mockito.verify((Object)monitoredContainer)).registerMetricsForPipelineResult();
    }

    private static class TestDoFnFunction
    extends FlinkStatefulDoFnFunction {
        public TestDoFnFunction(@UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized WindowingStrategy windowingStrategy, @UnknownKeyFor @NonNull @Initialized Map sideInputs, @UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized Map outputMap, @UnknownKeyFor @NonNull @Initialized TupleTag mainOutputTag, @UnknownKeyFor @NonNull @Initialized Coder inputCoder, @UnknownKeyFor @NonNull @Initialized Map outputCoderMap, @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation, @UnknownKeyFor @NonNull @Initialized Map sideInputMapping) {
            super(new IdentityFn(), stepName, windowingStrategy, sideInputs, options, outputMap, mainOutputTag, inputCoder, outputCoderMap, doFnSchemaInformation, sideInputMapping);
        }

        public @UnknownKeyFor @NonNull @Initialized RuntimeContext getRuntimeContext() {
            return (RuntimeContext)Mockito.mock(RuntimeContext.class);
        }

        private static class IdentityFn<@UnknownKeyFor T>
        extends DoFn<T, T> {
            private IdentityFn() {
            }

            @DoFn.ProcessElement
            public void processElement(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                c.output(c.element());
            }
        }
    }
}

