/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.streaming;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkTestPipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.flink.test.util.AbstractTestBase;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class GroupByNullKeyTest
extends AbstractTestBase
implements Serializable {
    protected @UnknownKeyFor @NonNull @Initialized String resultDir;
    protected @UnknownKeyFor @NonNull @Initialized String resultPath;
    static final @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] EXPECTED_RESULT = new String[]{"k: null v: user1 user1 user1 user2 user2 user2 user2 user3"};

    @Before
    public void preSubmit() throws @UnknownKeyFor @NonNull @Initialized Exception {
        File resultParent = this.createAndRegisterTempFile("result");
        this.resultDir = resultParent.toURI().toString();
        this.resultPath = new File(resultParent, "file.txt").getAbsolutePath();
    }

    @After
    public void postSubmit() throws @UnknownKeyFor @NonNull @Initialized Exception {
        GroupByNullKeyTest.compareResultsByLinesInMemory((String)Joiner.on((char)'\n').join((Object[])EXPECTED_RESULT), (String)this.resultDir);
    }

    @Test
    public void testProgram() throws @UnknownKeyFor @NonNull @Initialized Exception {
        FlinkTestPipeline p = FlinkTestPipeline.createForStreaming();
        ((FlinkPipelineOptions)p.getOptions().as(FlinkPipelineOptions.class)).setParallelism(Integer.valueOf(1));
        PCollection output = (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)p.apply((PTransform)Create.of(Arrays.asList(KV.of((Object)0, (Object)"user1"), KV.of((Object)1, (Object)"user1"), KV.of((Object)2, (Object)"user1"), KV.of((Object)10, (Object)"user2"), KV.of((Object)1, (Object)"user2"), KV.of((Object)15000, (Object)"user2"), KV.of((Object)12000, (Object)"user2"), KV.of((Object)25000, (Object)"user3"))))).apply((PTransform)ParDo.of((DoFn)new ExtractUserAndTimestamp()))).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardHours((long)1L))).triggering((Trigger)AfterWatermark.pastEndOfWindow()).withAllowedLateness(Duration.ZERO).discardingFiredPanes())).apply((PTransform)ParDo.of((DoFn)new DoFn<String, KV<Void, String>>(){

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                String elem = (String)c.element();
                c.output((Object)KV.of(null, (Object)elem));
            }
        }))).apply((PTransform)GroupByKey.create())).apply((PTransform)ParDo.of((DoFn)new DoFn<KV<Void, Iterable<String>>, String>(){

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                KV elem = (KV)c.element();
                StringBuilder str = new StringBuilder();
                str.append("k: " + elem.getKey() + " v:");
                for (String v : (Iterable)elem.getValue()) {
                    str.append(" " + v);
                }
                c.output((Object)str.toString());
            }
        }));
        output.apply((PTransform)TextIO.write().to(this.resultPath));
        p.run();
    }

    private static class ExtractUserAndTimestamp
    extends DoFn<KV<Integer, String>, String> {
        private ExtractUserAndTimestamp() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            KV record = (KV)c.element();
            int timestamp = (Integer)record.getKey();
            String userName = (String)record.getValue();
            if (userName != null) {
                c.outputWithTimestamp((Object)userName, new Instant((long)timestamp));
            }
        }
    }
}

