/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.batch;

import java.util.Arrays;
import java.util.Objects;
import org.apache.beam.runners.flink.FlinkCapabilities;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkTestPipeline;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.flink.test.util.AbstractTestBase;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class NonMergingGroupByKeyTest
extends AbstractTestBase {
    @Test
    public void testDisabledReIterationThrowsAnException() {
        Assume.assumeTrue((boolean)FlinkCapabilities.supportsOutputDuringClosing());
        FlinkTestPipeline p = FlinkTestPipeline.createForBatch();
        ((PCollection)((PCollection)p.apply((PTransform)Create.of(Arrays.asList(KV.of((Object)"a", (Object)1), KV.of((Object)"b", (Object)2), KV.of((Object)"c", (Object)3))))).apply((PTransform)GroupByKey.create())).apply((PTransform)ParDo.of(new ReiterateDoFn()));
        Pipeline.PipelineExecutionException resultException = null;
        try {
            p.run().waitUntilFinish();
        }
        catch (Pipeline.PipelineExecutionException exception) {
            resultException = exception;
        }
        Assert.assertEquals(IllegalStateException.class, Objects.requireNonNull(resultException).getCause().getClass());
        Assert.assertTrue((boolean)resultException.getCause().getMessage().contains("GBK result is not re-iterable."));
    }

    @Test
    public void testEnabledReIterationDoesNotThrowAnException() {
        FlinkTestPipeline p = FlinkTestPipeline.createForBatch();
        ((FlinkPipelineOptions)p.getOptions().as(FlinkPipelineOptions.class)).setReIterableGroupByKeyResult(Boolean.valueOf(true));
        ((PCollection)((PCollection)p.apply((PTransform)Create.of(Arrays.asList(KV.of((Object)"a", (Object)1), KV.of((Object)"b", (Object)2), KV.of((Object)"c", (Object)3))))).apply((PTransform)GroupByKey.create())).apply((PTransform)ParDo.of(new ReiterateDoFn()));
        PipelineResult.State state = p.run().waitUntilFinish();
        Assert.assertEquals((Object)PipelineResult.State.DONE, (Object)state);
    }

    private static class ReiterateDoFn<@UnknownKeyFor K, @UnknownKeyFor V>
    extends DoFn<KV<K, Iterable<V>>, Void> {
        private ReiterateDoFn() {
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>> el) {
            ((Iterable)el.getValue()).iterator();
            ((Iterable)el.getValue()).iterator();
        }
    }
}

