/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PipelineTranslation;
import org.apache.beam.runners.flink.FlinkJobInvoker;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkPipelineRunner;
import org.apache.beam.runners.jobsubmission.JobInvocation;
import org.apache.beam.runners.jobsubmission.PortablePipelineRunner;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.testing.CrashingRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.MoreExecutors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class ReadSourcePortableTest
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ReadSourcePortableTest.class);
    @Parameterized.Parameter
    public @UnknownKeyFor @NonNull @Initialized boolean isStreaming;
    private static @UnknownKeyFor @NonNull @Initialized ListeningExecutorService flinkJobExecutor;

    @Parameterized.Parameters(name="streaming: {0}")
    public static @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] data() {
        return new Object[]{true, false};
    }

    @BeforeClass
    public static void setup() {
        flinkJobExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
    }

    @AfterClass
    public static void tearDown() throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
        flinkJobExecutor.shutdown();
        flinkJobExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        if (!flinkJobExecutor.isShutdown()) {
            LOG.warn("Could not shutdown Flink job executor");
        }
        flinkJobExecutor = null;
    }

    @Test(timeout=120000L)
    public void testExecution() throws @UnknownKeyFor @NonNull @Initialized Exception {
        PipelineOptions options = PipelineOptionsFactory.fromArgs((String[])new String[]{"--experiments=beam_fn_api"}).create();
        options.setRunner(CrashingRunner.class);
        ((FlinkPipelineOptions)options.as(FlinkPipelineOptions.class)).setFlinkMaster("[local]");
        ((FlinkPipelineOptions)options.as(FlinkPipelineOptions.class)).setStreaming(this.isStreaming);
        ((FlinkPipelineOptions)options.as(FlinkPipelineOptions.class)).setParallelism(Integer.valueOf(2));
        ((PortablePipelineOptions)options.as(PortablePipelineOptions.class)).setDefaultEnvironmentType("EMBEDDED");
        Pipeline p = Pipeline.create((PipelineOptions)options);
        PCollection result = (PCollection)p.apply((PTransform)GenerateSequence.from((long)0L).to(10L));
        PAssert.that((PCollection)result).containsInAnyOrder((Iterable)ImmutableList.of((Object)0L, (Object)1L, (Object)2L, (Object)3L, (Object)4L, (Object)5L, (Object)6L, (Object)7L, (Object)8L, (Object)9L));
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p);
        JobInvocation jobInvocation = FlinkJobInvoker.create(null).createJobInvocation("fakeId", "fakeRetrievalToken", flinkJobExecutor, pipelineProto, (FlinkPipelineOptions)options.as(FlinkPipelineOptions.class), (PortablePipelineRunner)new FlinkPipelineRunner((FlinkPipelineOptions)options.as(FlinkPipelineOptions.class), null, Collections.emptyList()));
        jobInvocation.start();
        while (jobInvocation.getState() != JobApi.JobState.Enum.DONE) {
            Thread.sleep(100L);
        }
    }
}

