/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import org.apache.beam.runners.flink.FlinkRunner;
import org.apache.beam.runners.flink.PipelineTranslationModeOptimizer;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.PTransform;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class PipelineTranslationModeOptimizerTest {
    @Test
    public void testUnboundedCollectionProducingTransform() {
        PipelineOptions options = PipelineOptionsFactory.create();
        options.setRunner(FlinkRunner.class);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        pipeline.apply((PTransform)GenerateSequence.from((long)0L));
        MatcherAssert.assertThat((Object)PipelineTranslationModeOptimizer.hasUnboundedOutput((Pipeline)pipeline), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testBoundedCollectionProducingTransform() {
        PipelineOptions options = PipelineOptionsFactory.create();
        options.setRunner(FlinkRunner.class);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        pipeline.apply((PTransform)GenerateSequence.from((long)0L).to(10L));
        MatcherAssert.assertThat((Object)PipelineTranslationModeOptimizer.hasUnboundedOutput((Pipeline)pipeline), (Matcher)Matchers.is((Object)false));
    }
}

