/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.util.Collections;
import java.util.Map;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkStreamingPipelineTranslator;
import org.apache.beam.runners.flink.TestFlinkRunner;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.DynamicFileDestinations;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.PValues;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FlinkTransformOverridesTest {
    @Rule
    public transient @UnknownKeyFor @NonNull @Initialized TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testRunnerDeterminedSharding() {
        FlinkPipelineOptions options = FlinkPipelineOptions.defaults();
        options.setRunner(TestFlinkRunner.class);
        options.setFlinkMaster("[auto]");
        options.setParallelism(Integer.valueOf(5));
        TestPipeline p = TestPipeline.fromOptions((PipelineOptions)options);
        FlinkStreamingPipelineTranslator.StreamingShardedWriteFactory factory = new FlinkStreamingPipelineTranslator.StreamingShardedWriteFactory(p.getOptions());
        WriteFiles original = WriteFiles.to((FileBasedSink)new TestSink(this.tmpFolder.toString()));
        PCollection objs = (PCollection)p.apply((PTransform)Create.empty((Coder)VoidCoder.of()));
        AppliedPTransform originalApplication = AppliedPTransform.of((String)"writefiles", (Map)PValues.expandInput((PInput)objs), Collections.emptyMap(), (PTransform)original, (Pipeline)p);
        WriteFiles replacement = (WriteFiles)factory.getReplacementTransform(originalApplication).getTransform();
        Assert.assertThat((Object)replacement, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)original)));
        Assert.assertThat((Object)((Integer)replacement.getNumShardsProvider().get()), (Matcher)Matchers.is((Object)10));
    }

    private static class TestSink
    extends FileBasedSink<Object, Void, Object> {
        private static final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileBasedSink.FilenamePolicy FILENAME_POLICY = new FileBasedSink.FilenamePolicy(){

            public @UnknownKeyFor @NonNull @Initialized ResourceId windowedFilename(@UnknownKeyFor @NonNull @Initialized int shardNumber, @UnknownKeyFor @NonNull @Initialized int numShards, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized FileBasedSink.OutputFileHints outputFileHints) {
                throw new UnsupportedOperationException("should not be called");
            }

            public @Nullable @UnknownKeyFor @Initialized ResourceId unwindowedFilename(@UnknownKeyFor @NonNull @Initialized int shardNumber, @UnknownKeyFor @NonNull @Initialized int numShards, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized FileBasedSink.OutputFileHints outputFileHints) {
                throw new UnsupportedOperationException("should not be called");
            }
        };

        public void validate(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        }

        TestSink(@UnknownKeyFor @NonNull @Initialized String tmpFolder) {
            super((ValueProvider)ValueProvider.StaticValueProvider.of((Object)FileSystems.matchNewResource((String)tmpFolder, (boolean)true)), DynamicFileDestinations.constant((FileBasedSink.FilenamePolicy)FILENAME_POLICY, (SerializableFunction)SerializableFunctions.identity()));
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileBasedSink.WriteOperation<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized Object> createWriteOperation() {
            throw new IllegalArgumentException("Should not be used");
        }
    }
}

