/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.SerializationUtils;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.translation.wrappers.streaming.DoFnOperator;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;

public class FlinkPipelineOptionsTest {
    private static @UnknownKeyFor @NonNull @Initialized MyOptions options = (MyOptions)PipelineOptionsFactory.fromArgs((String[])new String[]{"--testOption=nothing"}).as(MyOptions.class);

    @Test
    public void testDefaults() {
        FlinkPipelineOptions options = FlinkPipelineOptions.defaults();
        MatcherAssert.assertThat((Object)options.getParallelism(), (Matcher)Is.is((Object)-1));
        MatcherAssert.assertThat((Object)options.getMaxParallelism(), (Matcher)Is.is((Object)-1));
        MatcherAssert.assertThat((Object)options.getFlinkMaster(), (Matcher)Is.is((Object)"[auto]"));
        MatcherAssert.assertThat((Object)options.getFilesToStage(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)options.getLatencyTrackingInterval(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)options.getShutdownSourcesAfterIdleMs(), (Matcher)Is.is((Object)-1L));
        MatcherAssert.assertThat((Object)options.getObjectReuse(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)options.getCheckpointingMode(), (Matcher)Is.is((Object)CheckpointingMode.EXACTLY_ONCE.name()));
        MatcherAssert.assertThat((Object)options.getMinPauseBetweenCheckpoints(), (Matcher)Is.is((Object)-1L));
        MatcherAssert.assertThat((Object)options.getCheckpointingInterval(), (Matcher)Is.is((Object)-1L));
        MatcherAssert.assertThat((Object)options.getCheckpointTimeoutMillis(), (Matcher)Is.is((Object)-1L));
        MatcherAssert.assertThat((Object)options.getNumConcurrentCheckpoints(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)options.getFailOnCheckpointingErrors(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)options.getFinishBundleBeforeCheckpointing(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)options.getNumberOfExecutionRetries(), (Matcher)Is.is((Object)-1));
        MatcherAssert.assertThat((Object)options.getExecutionRetryDelay(), (Matcher)Is.is((Object)-1L));
        MatcherAssert.assertThat((Object)options.getRetainExternalizedCheckpointsOnCancellation(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)options.getStateBackendFactory(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)options.getStateBackend(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)options.getStateBackendStoragePath(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)options.getMaxBundleSize(), (Matcher)Is.is((Object)1000L));
        MatcherAssert.assertThat((Object)options.getMaxBundleTimeMills(), (Matcher)Is.is((Object)1000L));
        MatcherAssert.assertThat((Object)options.getExecutionModeForBatch(), (Matcher)Is.is((Object)ExecutionMode.PIPELINED.name()));
        MatcherAssert.assertThat((Object)options.getSavepointPath(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)options.getAllowNonRestoredState(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)options.getDisableMetrics(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)options.getFasterCopy(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=Exception.class)
    public void parDoBaseClassPipelineOptionsNullTest() {
        TupleTag mainTag = new TupleTag("main-output");
        WindowedValue.ValueOnlyWindowedValueCoder coder = WindowedValue.getValueOnlyCoder((Coder)StringUtf8Coder.of());
        new DoFnOperator((DoFn)new TestDoFn(), "stepName", (Coder)coder, Collections.emptyMap(), mainTag, Collections.emptyList(), (DoFnOperator.OutputManagerFactory)new DoFnOperator.MultiOutputOutputManagerFactory(mainTag, (Coder)coder, new SerializablePipelineOptions((PipelineOptions)FlinkPipelineOptions.defaults())), WindowingStrategy.globalDefault(), new HashMap(), Collections.emptyList(), null, null, null, DoFnSchemaInformation.create(), Collections.emptyMap());
    }

    @Test
    public void parDoBaseClassPipelineOptionsSerializationTest() throws @UnknownKeyFor @NonNull @Initialized Exception {
        TupleTag mainTag = new TupleTag("main-output");
        WindowedValue.ValueOnlyWindowedValueCoder coder = WindowedValue.getValueOnlyCoder((Coder)StringUtf8Coder.of());
        DoFnOperator doFnOperator = new DoFnOperator((DoFn)new TestDoFn(), "stepName", (Coder)coder, Collections.emptyMap(), mainTag, Collections.emptyList(), (DoFnOperator.OutputManagerFactory)new DoFnOperator.MultiOutputOutputManagerFactory(mainTag, (Coder)coder, new SerializablePipelineOptions((PipelineOptions)FlinkPipelineOptions.defaults())), WindowingStrategy.globalDefault(), new HashMap(), Collections.emptyList(), (PipelineOptions)options, null, null, DoFnSchemaInformation.create(), Collections.emptyMap());
        byte[] serialized = SerializationUtils.serialize((Serializable)doFnOperator);
        DoFnOperator deserialized = (DoFnOperator)SerializationUtils.deserialize((byte[])serialized);
        TypeInformation typeInformation = TypeInformation.of((TypeHint)new TypeHint<WindowedValue<Object>>(){});
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness((OneInputStreamOperator)deserialized, typeInformation.createSerializer(new ExecutionConfig()));
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)WindowedValue.of((Object)new Object(), (Instant)Instant.now(), (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.NO_FIRING)));
        testHarness.close();
    }

    private static class TestDoFn
    extends DoFn<String, String> {
        private TestDoFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Assert.assertNotNull((Object)c.getPipelineOptions());
            Assert.assertEquals((Object)options.getTestOption(), (Object)((MyOptions)c.getPipelineOptions().as(MyOptions.class)).getTestOption());
        }
    }

    public static interface MyOptions
    extends FlinkPipelineOptions {
        @Description(value="Bla bla bla")
        @Default.String(value="Hello")
        public @UnknownKeyFor @NonNull @Initialized String getTestOption();

        public void setTestOption(@UnknownKeyFor @NonNull @Initialized String var1);
    }
}

