/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers;

import org.apache.beam.runners.flink.metrics.FlinkMetricContainer;
import org.apache.beam.runners.flink.translation.wrappers.SourceInputFormat;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.CountingSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Test;
import org.mockito.Mockito;
import org.powermock.reflect.Whitebox;

public class SourceInputFormatTest {
    @Test
    public void testAccumulatorRegistrationOnOperatorClose() throws @UnknownKeyFor @NonNull @Initialized Exception {
        TestSourceInputFormat sourceInputFormat = new TestSourceInputFormat("step", CountingSource.upTo((long)10L), PipelineOptionsFactory.create());
        sourceInputFormat.open(sourceInputFormat.createInputSplits(1)[0]);
        String metricContainerFieldName = "metricContainer";
        FlinkMetricContainer monitoredContainer = (FlinkMetricContainer)Mockito.spy((Object)((FlinkMetricContainer)Whitebox.getInternalState(sourceInputFormat, (String)metricContainerFieldName)));
        Whitebox.setInternalState(sourceInputFormat, (String)metricContainerFieldName, (Object)monitoredContainer);
        sourceInputFormat.close();
        ((FlinkMetricContainer)Mockito.verify((Object)monitoredContainer)).registerMetricsForPipelineResult();
    }

    private static class TestSourceInputFormat<@UnknownKeyFor T>
    extends SourceInputFormat<T> {
        public TestSourceInputFormat(@UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized BoundedSource initialSource, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            super(stepName, initialSource, options);
        }

        public @UnknownKeyFor @NonNull @Initialized RuntimeContext getRuntimeContext() {
            return (RuntimeContext)Mockito.mock(RuntimeContext.class);
        }
    }
}

