/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.translation.types.CoderTypeSerializer;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.flink.api.common.typeutils.ComparatorTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;

public class CoderTypeSerializerTest
implements Serializable {
    @Test
    public void shouldWriteAndReadSnapshotForAnonymousClassCoder() throws @UnknownKeyFor @NonNull @Initialized Exception {
        AtomicCoder<String> anonymousClassCoder = new AtomicCoder<String>(){

            public void encode(@UnknownKeyFor @NonNull @Initialized String value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) {
            }

            public @UnknownKeyFor @NonNull @Initialized String decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) {
                return "";
            }
        };
        this.testWriteAndReadConfigSnapshot((Coder<String>)anonymousClassCoder);
    }

    @Test
    public void shouldWriteAndReadSnapshotForConcreteClassCoder() throws @UnknownKeyFor @NonNull @Initialized Exception {
        StringUtf8Coder concreteClassCoder = StringUtf8Coder.of();
        this.testWriteAndReadConfigSnapshot((Coder<String>)concreteClassCoder);
    }

    private void testWriteAndReadConfigSnapshot(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized String> coder) throws @UnknownKeyFor @NonNull @Initialized IOException {
        CoderTypeSerializer serializer = new CoderTypeSerializer(coder, new SerializablePipelineOptions(PipelineOptionsFactory.create()));
        TypeSerializerSnapshot writtenSnapshot = serializer.snapshotConfiguration();
        ComparatorTestBase.TestOutputView outView = new ComparatorTestBase.TestOutputView();
        writtenSnapshot.writeSnapshot((DataOutputView)outView);
        CoderTypeSerializer.LegacySnapshot readSnapshot = new CoderTypeSerializer.LegacySnapshot();
        readSnapshot.readSnapshot(writtenSnapshot.getCurrentVersion(), (DataInputView)outView.getInputView(), this.getClass().getClassLoader());
        MatcherAssert.assertThat((Object)readSnapshot.restoreSerializer(), (Matcher)Is.is((Object)serializer));
    }
}

