/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.streaming;

import com.google.api.services.bigquery.model.TableRow;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.beam.runners.flink.FlinkTestPipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.flink.test.util.AbstractTestBase;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TopWikipediaSessionsTest
extends AbstractTestBase
implements Serializable {
    protected @UnknownKeyFor @NonNull @Initialized String resultDir;
    protected @UnknownKeyFor @NonNull @Initialized String resultPath;
    static final @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] EXPECTED_RESULT = new String[]{"user: user1 value:3", "user: user1 value:1", "user: user2 value:4", "user: user2 value:6", "user: user3 value:7", "user: user3 value:2"};

    @Before
    public void preSubmit() throws @UnknownKeyFor @NonNull @Initialized Exception {
        File resultParent = this.createAndRegisterTempFile("result");
        this.resultDir = resultParent.toURI().toString();
        this.resultPath = new File(resultParent, "file.txt").getAbsolutePath();
    }

    @After
    public void postSubmit() throws @UnknownKeyFor @NonNull @Initialized Exception {
        TopWikipediaSessionsTest.compareResultsByLinesInMemory((String)Joiner.on((char)'\n').join((Object[])EXPECTED_RESULT), (String)this.resultDir);
    }

    @Test
    public void testProgram() throws @UnknownKeyFor @NonNull @Initialized Exception {
        FlinkTestPipeline p = FlinkTestPipeline.createForStreaming();
        Long now = (System.currentTimeMillis() + 10000L) / 1000L;
        PCollection output = (PCollection)((PCollection)((PCollection)((PCollection)p.apply((PTransform)Create.of(Arrays.asList(new TableRow().set("timestamp", (Object)now).set("contributor_username", (Object)"user1"), new TableRow().set("timestamp", (Object)(now + 10L)).set("contributor_username", (Object)"user3"), new TableRow().set("timestamp", (Object)now).set("contributor_username", (Object)"user2"), new TableRow().set("timestamp", (Object)now).set("contributor_username", (Object)"user1"), new TableRow().set("timestamp", (Object)(now + 2L)).set("contributor_username", (Object)"user1"), new TableRow().set("timestamp", (Object)now).set("contributor_username", (Object)"user2"), new TableRow().set("timestamp", (Object)(now + 1L)).set("contributor_username", (Object)"user2"), new TableRow().set("timestamp", (Object)(now + 5L)).set("contributor_username", (Object)"user2"), new TableRow().set("timestamp", (Object)(now + 7L)).set("contributor_username", (Object)"user2"), new TableRow().set("timestamp", (Object)(now + 8L)).set("contributor_username", (Object)"user2"), new TableRow().set("timestamp", (Object)(now + 200L)).set("contributor_username", (Object)"user2"), new TableRow().set("timestamp", (Object)(now + 230L)).set("contributor_username", (Object)"user1"), new TableRow().set("timestamp", (Object)(now + 230L)).set("contributor_username", (Object)"user2"), new TableRow().set("timestamp", (Object)(now + 240L)).set("contributor_username", (Object)"user2"), new TableRow().set("timestamp", (Object)(now + 245L)).set("contributor_username", (Object)"user3"), new TableRow().set("timestamp", (Object)(now + 235L)).set("contributor_username", (Object)"user3"), new TableRow().set("timestamp", (Object)(now + 236L)).set("contributor_username", (Object)"user3"), new TableRow().set("timestamp", (Object)(now + 237L)).set("contributor_username", (Object)"user3"), new TableRow().set("timestamp", (Object)(now + 238L)).set("contributor_username", (Object)"user3"), new TableRow().set("timestamp", (Object)(now + 239L)).set("contributor_username", (Object)"user3"), new TableRow().set("timestamp", (Object)(now + 240L)).set("contributor_username", (Object)"user3"), new TableRow().set("timestamp", (Object)(now + 241L)).set("contributor_username", (Object)"user2"), new TableRow().set("timestamp", (Object)now).set("contributor_username", (Object)"user3"))))).apply((PTransform)ParDo.of((DoFn)new DoFn<TableRow, String>(){

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                TableRow row = (TableRow)c.element();
                long timestamp = ((Integer)row.get((Object)"timestamp")).intValue();
                String userName = (String)row.get((Object)"contributor_username");
                if (userName != null) {
                    c.outputWithTimestamp((Object)userName, new Instant(timestamp * 1000L));
                }
            }
        }))).apply((PTransform)Window.into((WindowFn)Sessions.withGapDuration((Duration)Duration.standardMinutes((long)1L))))).apply(Count.perElement());
        PCollection format = (PCollection)output.apply((PTransform)ParDo.of((DoFn)new DoFn<KV<String, Long>, String>(){

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                KV el = (KV)c.element();
                String out = "user: " + (String)el.getKey() + " value:" + el.getValue();
                c.output((Object)out);
            }
        }));
        format.apply((PTransform)TextIO.write().to(this.resultPath));
        p.run();
    }
}

