/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.metrics;

import java.util.List;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.runners.core.metrics.DistributionData;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.MonitoringInfoMetricName;
import org.apache.beam.runners.core.metrics.SimpleMonitoringInfoBuilder;
import org.apache.beam.runners.flink.metrics.FlinkMetricContainer;
import org.apache.beam.runners.flink.metrics.MetricsAccumulator;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.Gauge;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class FlinkMetricContainerTest {
    @Mock
    private @UnknownKeyFor @NonNull @Initialized RuntimeContext runtimeContext;
    @Mock
    private @UnknownKeyFor @NonNull @Initialized MetricGroup metricGroup;
    @UnknownKeyFor @NonNull @Initialized FlinkMetricContainer container;

    @Before
    public void beforeTest() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.runtimeContext.getAccumulator(ArgumentMatchers.anyString())).thenReturn((Object)new MetricsAccumulator());
        Mockito.when((Object)this.runtimeContext.getMetricGroup()).thenReturn((Object)this.metricGroup);
        this.container = new FlinkMetricContainer(this.runtimeContext);
    }

    @Test
    public void testMetricNameGeneration() {
        MetricKey key = MetricKey.create((String)"step", (MetricName)MetricName.named((String)"namespace", (String)"name"));
        String name = FlinkMetricContainer.getFlinkMetricNameString((MetricKey)key);
        MatcherAssert.assertThat((Object)name, (Matcher)CoreMatchers.is((Object)"namespace.name"));
    }

    @Test
    public void testCounter() {
        SimpleCounter flinkCounter = new SimpleCounter();
        Mockito.when((Object)this.metricGroup.counter("namespace.name")).thenReturn((Object)flinkCounter);
        MetricsContainerImpl step = this.container.getMetricsContainer("step");
        MetricName metricName = MetricName.named((String)"namespace", (String)"name");
        Counter counter = step.getCounter(metricName);
        counter.inc();
        counter.inc();
        MatcherAssert.assertThat((Object)flinkCounter.getCount(), (Matcher)CoreMatchers.is((Object)0L));
        this.container.updateMetrics("step");
        MatcherAssert.assertThat((Object)flinkCounter.getCount(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testGauge() {
        FlinkMetricContainer.FlinkGauge flinkGauge = new FlinkMetricContainer.FlinkGauge(GaugeResult.empty());
        Mockito.when((Object)this.metricGroup.gauge((String)Matchers.eq((Object)"namespace.name"), (org.apache.flink.metrics.Gauge)Matchers.anyObject())).thenReturn((Object)flinkGauge);
        MetricsContainerImpl step = this.container.getMetricsContainer("step");
        MetricName metricName = MetricName.named((String)"namespace", (String)"name");
        Gauge gauge = step.getGauge(metricName);
        MatcherAssert.assertThat((Object)flinkGauge.getValue(), (Matcher)CoreMatchers.is((Object)-1L));
        this.container.updateMetrics("step");
        gauge.set(1L);
        gauge.set(42L);
        this.container.updateMetrics("step");
        MatcherAssert.assertThat((Object)flinkGauge.getValue(), (Matcher)CoreMatchers.is((Object)42L));
    }

    @Test
    public void testMonitoringInfoUpdate() {
        SimpleCounter userCounter = new SimpleCounter();
        Mockito.when((Object)this.metricGroup.counter("ns1.metric1")).thenReturn((Object)userCounter);
        SimpleCounter pCollectionCounter = new SimpleCounter();
        Mockito.when((Object)this.metricGroup.counter("pcoll.metric:element_count:v1")).thenReturn((Object)pCollectionCounter);
        SimpleCounter pTransformCounter = new SimpleCounter();
        Mockito.when((Object)this.metricGroup.counter("anyPTransform.myMetric")).thenReturn((Object)pTransformCounter);
        MetricsApi.MonitoringInfo userCountMonitoringInfo = new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.USER_SUM_INT64).setLabel("NAMESPACE", "ns1").setLabel("NAME", "metric1").setLabel("PTRANSFORM", "anyPTransform").setInt64SumValue(111L).build();
        Assert.assertNotNull((Object)userCountMonitoringInfo);
        MetricsApi.MonitoringInfo pCollectionScoped = new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.ELEMENT_COUNT).setInt64SumValue(222L).setLabel("PCOLLECTION", "pcoll").setLabel("PTRANSFORM", "anyPTransform").build();
        Assert.assertNotNull((Object)pCollectionScoped);
        MetricsApi.MonitoringInfo transformScoped = new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.START_BUNDLE_MSECS).setInt64SumValue(333L).setLabel("NAME", "myMetric").setLabel("PTRANSFORM", "anyPTransform").build();
        Assert.assertNotNull((Object)transformScoped);
        MatcherAssert.assertThat((Object)userCounter.getCount(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)pCollectionCounter.getCount(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)pTransformCounter.getCount(), (Matcher)CoreMatchers.is((Object)0L));
        this.container.updateMetrics("step", (List)ImmutableList.of((Object)userCountMonitoringInfo, (Object)pCollectionScoped, (Object)transformScoped));
        MatcherAssert.assertThat((Object)userCounter.getCount(), (Matcher)CoreMatchers.is((Object)111L));
        MatcherAssert.assertThat((Object)pCollectionCounter.getCount(), (Matcher)CoreMatchers.is((Object)222L));
        MatcherAssert.assertThat((Object)pTransformCounter.getCount(), (Matcher)CoreMatchers.is((Object)333L));
    }

    @Test
    public void testDropUnexpectedMonitoringInfoTypes() {
        MetricsContainerImpl step = this.container.getMetricsContainer("step");
        MetricsApi.MonitoringInfo intCounter = new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.USER_SUM_INT64).setLabel("NAMESPACE", "ns1").setLabel("NAME", "int_counter").setLabel("PTRANSFORM", "step").setInt64SumValue(111L).build();
        MetricsApi.MonitoringInfo doubleCounter = new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.USER_SUM_DOUBLE).setLabel("NAMESPACE", "ns2").setLabel("NAME", "double_counter").setLabel("PTRANSFORM", "step").setDoubleSumValue(222.0).build();
        MetricsApi.MonitoringInfo intDistribution = new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.USER_DISTRIBUTION_INT64).setLabel("NAMESPACE", "ns3").setLabel("NAME", "int_distribution").setLabel("PTRANSFORM", "step").setInt64DistributionValue(DistributionData.create((long)30L, (long)10L, (long)1L, (long)5L)).build();
        MetricsApi.MonitoringInfo doubleDistribution = new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.USER_DISTRIBUTION_DOUBLE).setLabel("NAMESPACE", "ns4").setLabel("NAME", "double_distribution").setLabel("PTRANSFORM", "step").setDoubleDistributionValue(10L, 30.0, 1.0, 5.0).build();
        SimpleCounter counter = new SimpleCounter();
        Mockito.when((Object)this.metricGroup.counter("ns1.int_counter")).thenReturn((Object)counter);
        this.container.updateMetrics("step", (List)ImmutableList.of((Object)intCounter, (Object)doubleCounter, (Object)intDistribution, (Object)doubleDistribution));
        ((MetricGroup)Mockito.verify((Object)this.metricGroup)).counter((String)Matchers.eq((Object)"ns1.int_counter"));
        MatcherAssert.assertThat((Object)counter.getCount(), (Matcher)CoreMatchers.is((Object)111L));
        long count = step.tryGetCounter((MetricName)MonitoringInfoMetricName.of((MetricsApi.MonitoringInfo)intCounter)).getCumulative();
        MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.is((Object)111L));
        ((MetricGroup)Mockito.verify((Object)this.metricGroup)).gauge((String)Matchers.eq((Object)"ns3.int_distribution"), (org.apache.flink.metrics.Gauge)((FlinkMetricContainer.FlinkDistributionGauge)Matchers.argThat((ArgumentMatcher)new ArgumentMatcher<FlinkMetricContainer.FlinkDistributionGauge>(){

            public @UnknownKeyFor @NonNull @Initialized boolean matches(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized FlinkMetricContainer.FlinkDistributionGauge argument) {
                DistributionResult actual = argument.getValue();
                DistributionResult expected = DistributionResult.create((long)30L, (long)10L, (long)1L, (long)5L);
                return actual.equals(expected);
            }
        })));
        DistributionData distributionData = step.getDistribution((MetricName)MonitoringInfoMetricName.of((MetricsApi.MonitoringInfo)intDistribution)).getCumulative();
        MatcherAssert.assertThat((Object)distributionData, (Matcher)CoreMatchers.is((Object)DistributionData.create((long)30L, (long)10L, (long)1L, (long)5L)));
    }

    @Test
    public void testDistribution() {
        FlinkMetricContainer.FlinkDistributionGauge flinkGauge = new FlinkMetricContainer.FlinkDistributionGauge(DistributionResult.IDENTITY_ELEMENT);
        Mockito.when((Object)this.metricGroup.gauge((String)Matchers.eq((Object)"namespace.name"), (org.apache.flink.metrics.Gauge)Matchers.anyObject())).thenReturn((Object)flinkGauge);
        MetricsContainerImpl step = this.container.getMetricsContainer("step");
        MetricName metricName = MetricName.named((String)"namespace", (String)"name");
        Distribution distribution = step.getDistribution(metricName);
        MatcherAssert.assertThat((Object)flinkGauge.getValue(), (Matcher)CoreMatchers.is((Object)DistributionResult.IDENTITY_ELEMENT));
        this.container.updateMetrics("step");
        distribution.update(42L);
        distribution.update(-23L);
        distribution.update(0L);
        distribution.update(1L);
        this.container.updateMetrics("step");
        MatcherAssert.assertThat((Object)flinkGauge.getValue().getMax(), (Matcher)CoreMatchers.is((Object)42L));
        MatcherAssert.assertThat((Object)flinkGauge.getValue().getMin(), (Matcher)CoreMatchers.is((Object)-23L));
        MatcherAssert.assertThat((Object)flinkGauge.getValue().getCount(), (Matcher)CoreMatchers.is((Object)4L));
        MatcherAssert.assertThat((Object)flinkGauge.getValue().getSum(), (Matcher)CoreMatchers.is((Object)20L));
        MatcherAssert.assertThat((Object)flinkGauge.getValue().getMean(), (Matcher)CoreMatchers.is((Object)5.0));
    }
}

