/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import akka.actor.ActorSystem;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.net.URI;
import org.apache.beam.runners.flink.RemoteMiniCluster;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.akka.AkkaRpcService;
import org.apache.flink.runtime.rpc.akka.AkkaRpcServiceConfiguration;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class RemoteMiniClusterImpl
extends RemoteMiniCluster {
    private @UnknownKeyFor @NonNull @Initialized int port;

    public RemoteMiniClusterImpl(@UnknownKeyFor @NonNull @Initialized MiniClusterConfiguration miniClusterConfiguration) {
        super(miniClusterConfiguration);
    }

    protected @UnknownKeyFor @NonNull @Initialized RpcService createRpcService(@UnknownKeyFor @NonNull @Initialized AkkaRpcServiceConfiguration akkaRpcServiceConfig, @UnknownKeyFor @NonNull @Initialized boolean remoteEnabled, @UnknownKeyFor @NonNull @Initialized String bindAddress) {
        Config akkaConfig = AkkaUtils.getAkkaConfig((Configuration)akkaRpcServiceConfig.getConfiguration(), (String)bindAddress, (int)0);
        Config effectiveAkkaConfig = AkkaUtils.testDispatcherConfig().withFallback((ConfigMergeable)akkaConfig);
        ActorSystem actorSystem = AkkaUtils.createActorSystem((Config)effectiveAkkaConfig);
        AkkaRpcService akkaRpcService = new AkkaRpcService(actorSystem, akkaRpcServiceConfig);
        this.port = akkaRpcService.getPort();
        return akkaRpcService;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int getClusterPort() {
        Preconditions.checkState((this.port > 0 ? 1 : 0) != 0, (Object)"Port not yet initialized. Start the cluster first.");
        return this.port;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int getRestPort() {
        try {
            return ((URI)this.getRestAddress().get()).getPort();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

