/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.io.File;
import org.apache.beam.runners.flink.FlinkTestPipeline;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.flink.test.util.AbstractTestBase;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ReadSourceStreamingTest
extends AbstractTestBase {
    protected @UnknownKeyFor @NonNull @Initialized String resultDir;
    protected @UnknownKeyFor @NonNull @Initialized String resultPath;
    private static final @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] EXPECTED_RESULT = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};

    @Before
    public void preSubmit() throws @UnknownKeyFor @NonNull @Initialized Exception {
        File resultParent = this.createAndRegisterTempFile("result");
        this.resultDir = resultParent.toURI().toString();
        this.resultPath = new File(resultParent, "file.txt").getAbsolutePath();
    }

    @After
    public void postSubmit() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ReadSourceStreamingTest.compareResultsByLinesInMemory((String)Joiner.on((char)'\n').join((Object[])EXPECTED_RESULT), (String)this.resultDir);
    }

    @Test
    public void testProgram() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ReadSourceStreamingTest.runProgram(this.resultPath);
    }

    private static void runProgram(@UnknownKeyFor @NonNull @Initialized String resultPath) {
        FlinkTestPipeline p = FlinkTestPipeline.createForStreaming();
        ((PCollection)((PCollection)p.apply((PTransform)GenerateSequence.from((long)0L).to(10L))).apply((PTransform)ParDo.of((DoFn)new DoFn<Long, String>(){

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                c.output((Object)((Long)c.element()).toString());
            }
        }))).apply((PTransform)TextIO.write().to(resultPath));
        p.run();
    }
}

