/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PipelineTranslation;
import org.apache.beam.runners.flink.FlinkJobInvoker;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkPipelineRunner;
import org.apache.beam.runners.jobsubmission.JobInvocation;
import org.apache.beam.runners.jobsubmission.PortablePipelineRunner;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.testing.CrashingRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.MoreExecutors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class PortableStateExecutionTest
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PortableStateExecutionTest.class);
    @Parameterized.Parameter
    public @UnknownKeyFor @NonNull @Initialized boolean isStreaming;
    private static @UnknownKeyFor @NonNull @Initialized ListeningExecutorService flinkJobExecutor;
    private static final @UnknownKeyFor @NonNull @Initialized int CLEAR_STATE = -1;
    private static final @UnknownKeyFor @NonNull @Initialized int WRITE_STATE = -2;

    @Parameterized.Parameters(name="streaming: {0}")
    public static @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] data() {
        return new Object[]{true, false};
    }

    @BeforeClass
    public static void setup() {
        flinkJobExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
    }

    @AfterClass
    public static void tearDown() throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
        flinkJobExecutor.shutdown();
        flinkJobExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        if (!flinkJobExecutor.isShutdown()) {
            LOG.warn("Could not shutdown Flink job executor");
        }
        flinkJobExecutor = null;
    }

    @Test(timeout=120000L)
    public void testExecution() throws @UnknownKeyFor @NonNull @Initialized Exception {
        PipelineOptions options = PipelineOptionsFactory.fromArgs((String[])new String[]{"--experiments=beam_fn_api"}).create();
        options.setRunner(CrashingRunner.class);
        ((FlinkPipelineOptions)options.as(FlinkPipelineOptions.class)).setFlinkMaster("[local]");
        ((FlinkPipelineOptions)options.as(FlinkPipelineOptions.class)).setStreaming(this.isStreaming);
        ((FlinkPipelineOptions)options.as(FlinkPipelineOptions.class)).setParallelism(Integer.valueOf(2));
        ((PortablePipelineOptions)options.as(PortablePipelineOptions.class)).setDefaultEnvironmentType("EMBEDDED");
        Pipeline p = Pipeline.create((PipelineOptions)options);
        PCollection output = (PCollection)((PCollection)((PCollection)p.apply((PTransform)Impulse.create())).apply((PTransform)ParDo.of((DoFn)new DoFn<byte[], KV<String, Integer>>(){

            @DoFn.ProcessElement
            public void process(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext ctx) {
                ctx.output((Object)KV.of((Object)"clearedState", (Object)1));
                ctx.output((Object)KV.of((Object)"clearedState", (Object)-1));
                ctx.output((Object)KV.of((Object)"bla1", (Object)42));
                ctx.output((Object)KV.of((Object)"bla", (Object)23));
                ctx.output((Object)KV.of((Object)"bla2", (Object)64));
                ctx.output((Object)KV.of((Object)"bla", (Object)1));
                ctx.output((Object)KV.of((Object)"bla", (Object)1));
                ctx.output((Object)KV.of((Object)"bla", (Object)-2));
                ctx.output((Object)KV.of((Object)"bla1", (Object)-2));
                ctx.output((Object)KV.of((Object)"bla2", (Object)-2));
                ctx.output((Object)KV.of((Object)"clearedState", (Object)-2));
            }
        }))).apply("statefulDoFn", (PTransform)ParDo.of((DoFn)new DoFn<KV<String, Integer>, KV<String, String>>(){
            @DoFn.StateId(value="valueState")
            private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Integer>> valueStateSpec = StateSpecs.value((Coder)VarIntCoder.of());
            @DoFn.StateId(value="valueState2")
            private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Integer>> valueStateSpec2 = StateSpecs.value((Coder)VarIntCoder.of());

            @DoFn.ProcessElement
            public void process(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext ctx, @DoFn.StateId(value="valueState") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Integer> valueState, @DoFn.StateId(value="valueState2") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Integer> valueState2) {
                this.performStateUpdates(ctx, valueState);
                this.performStateUpdates(ctx, valueState2);
            }

            private void performStateUpdates(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext ctx, @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Integer> valueState) {
                Integer value = (Integer)((KV)ctx.element()).getValue();
                if (value == null) {
                    throw new IllegalStateException();
                }
                switch (value) {
                    case -1: {
                        valueState.clear();
                        break;
                    }
                    case -2: {
                        Integer read = (Integer)valueState.read();
                        ctx.output((Object)KV.of((Object)((String)((KV)ctx.element()).getKey()), (Object)(read == null ? "null" : read.toString())));
                        break;
                    }
                    default: {
                        Integer currentState = (Integer)valueState.read();
                        currentState = currentState == null ? value : Integer.valueOf(currentState + value);
                        valueState.write((Object)currentState);
                    }
                }
            }
        }));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"bla", (Object)"25"), KV.of((Object)"bla1", (Object)"42"), KV.of((Object)"bla2", (Object)"64"), KV.of((Object)"clearedState", (Object)"null"), KV.of((Object)"bla", (Object)"25"), KV.of((Object)"bla1", (Object)"42"), KV.of((Object)"bla2", (Object)"64"), KV.of((Object)"clearedState", (Object)"null")});
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p);
        JobInvocation jobInvocation = FlinkJobInvoker.create(null).createJobInvocation("id", "none", flinkJobExecutor, pipelineProto, (FlinkPipelineOptions)options.as(FlinkPipelineOptions.class), (PortablePipelineRunner)new FlinkPipelineRunner((FlinkPipelineOptions)options.as(FlinkPipelineOptions.class), null, Collections.emptyList()));
        jobInvocation.start();
        while (jobInvocation.getState() != JobApi.JobState.Enum.DONE) {
            Thread.sleep(1000L);
        }
    }
}

