/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PipelineTranslation;
import org.apache.beam.runners.flink.FlinkJobInvoker;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkPipelineRunner;
import org.apache.beam.runners.jobsubmission.JobInvocation;
import org.apache.beam.runners.jobsubmission.PortablePipelineRunner;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.testing.CrashingRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.MoreExecutors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class PortableExecutionTest
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PortableExecutionTest.class);
    @Parameterized.Parameter
    public @UnknownKeyFor @NonNull @Initialized boolean isStreaming;
    private static @UnknownKeyFor @NonNull @Initialized ListeningExecutorService flinkJobExecutor;

    @Parameterized.Parameters(name="streaming: {0}")
    public static @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] data() {
        return new Object[]{true, false};
    }

    @BeforeClass
    public static void setup() {
        flinkJobExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
    }

    @AfterClass
    public static void tearDown() throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
        flinkJobExecutor.shutdown();
        flinkJobExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        if (!flinkJobExecutor.isShutdown()) {
            LOG.warn("Could not shutdown Flink job executor");
        }
        flinkJobExecutor = null;
    }

    @Test(timeout=120000L)
    public void testExecution() throws @UnknownKeyFor @NonNull @Initialized Exception {
        PipelineOptions options = PipelineOptionsFactory.fromArgs((String[])new String[]{"--experiments=beam_fn_api"}).create();
        options.setRunner(CrashingRunner.class);
        ((FlinkPipelineOptions)options.as(FlinkPipelineOptions.class)).setFlinkMaster("[local]");
        ((FlinkPipelineOptions)options.as(FlinkPipelineOptions.class)).setStreaming(this.isStreaming);
        ((FlinkPipelineOptions)options.as(FlinkPipelineOptions.class)).setParallelism(Integer.valueOf(2));
        ((PortablePipelineOptions)options.as(PortablePipelineOptions.class)).setDefaultEnvironmentType("EMBEDDED");
        Pipeline p = Pipeline.create((PipelineOptions)options);
        PCollection result = (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)p.apply("impulse", (PTransform)Impulse.create())).apply("create", (PTransform)ParDo.of((DoFn)new DoFn<byte[], String>(){

            @DoFn.ProcessElement
            public void process(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext ctxt) {
                ctxt.output((Object)"zero");
                ctxt.output((Object)"one");
                ctxt.output((Object)"two");
            }
        }))).apply("len", (PTransform)ParDo.of((DoFn)new DoFn<String, Long>(){

            @DoFn.ProcessElement
            public void process(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext ctxt) {
                ctxt.output((Object)((String)ctxt.element()).length());
            }
        }))).apply("addKeys", (PTransform)WithKeys.of((Object)"foo"))).setCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)BigEndianLongCoder.of())).apply("gbk", (PTransform)GroupByKey.create());
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"foo", (Object)ImmutableList.of((Object)4L, (Object)3L, (Object)3L))});
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)p);
        JobInvocation jobInvocation = FlinkJobInvoker.create(null).createJobInvocation("fakeId", "fakeRetrievalToken", flinkJobExecutor, pipelineProto, (FlinkPipelineOptions)options.as(FlinkPipelineOptions.class), (PortablePipelineRunner)new FlinkPipelineRunner((FlinkPipelineOptions)options.as(FlinkPipelineOptions.class), null, Collections.emptyList()));
        jobInvocation.start();
        while (jobInvocation.getState() != JobApi.JobState.Enum.DONE) {
            Thread.sleep(1000L);
        }
    }
}

