/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import org.apache.beam.runners.flink.FlinkStreamingPipelineTranslator;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.ShardedKey;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class FlinkStreamingPipelineTranslatorTest {
    @Test
    public void testAutoBalanceShardKeyResolvesMaxParallelism() {
        int parallelism = 3;
        MatcherAssert.assertThat((Object)new FlinkStreamingPipelineTranslator.FlinkAutoBalancedShardKeyShardingFunction(parallelism, -1, (Coder)StringUtf8Coder.of()).getMaxParallelism(), (Matcher)Matchers.equalTo((Object)KeyGroupRangeAssignment.computeDefaultMaxParallelism((int)parallelism)));
        MatcherAssert.assertThat((Object)new FlinkStreamingPipelineTranslator.FlinkAutoBalancedShardKeyShardingFunction(parallelism, 0, (Coder)StringUtf8Coder.of()).getMaxParallelism(), (Matcher)Matchers.equalTo((Object)KeyGroupRangeAssignment.computeDefaultMaxParallelism((int)parallelism)));
    }

    @Test
    public void testAutoBalanceShardKeyCacheIsNotSerialized() throws @UnknownKeyFor @NonNull @Initialized Exception {
        FlinkStreamingPipelineTranslator.FlinkAutoBalancedShardKeyShardingFunction fn = new FlinkStreamingPipelineTranslator.FlinkAutoBalancedShardKeyShardingFunction(2, 2, (Coder)StringUtf8Coder.of());
        Assert.assertNull((Object)fn.getCache());
        fn.assignShardKey((Object)"target/destination1", (Object)"one", 10);
        fn.assignShardKey((Object)"target/destination2", (Object)"two", 10);
        MatcherAssert.assertThat((Object)fn.getCache().size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)((FlinkStreamingPipelineTranslator.FlinkAutoBalancedShardKeyShardingFunction)SerializableUtils.clone((Serializable)fn)).getCache(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testAutoBalanceShardKeyCacheIsStable() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ShardedKey shardKey;
        int numShards = 50;
        FlinkStreamingPipelineTranslator.FlinkAutoBalancedShardKeyShardingFunction fn = new FlinkStreamingPipelineTranslator.FlinkAutoBalancedShardKeyShardingFunction(numShards / 2, numShards * 2, (Coder)StringUtf8Coder.of());
        ArrayList inputs = Lists.newArrayList();
        for (int i = 0; i < numShards * 100; ++i) {
            inputs.add(KV.of((Object)"target/destination/1", (Object)UUID.randomUUID().toString()));
            inputs.add(KV.of((Object)"target/destination/2", (Object)UUID.randomUUID().toString()));
            inputs.add(KV.of((Object)"target/destination/3", (Object)UUID.randomUUID().toString()));
        }
        HashMap<KV, ShardedKey> generatedKeys = new HashMap<KV, ShardedKey>();
        for (KV input : inputs) {
            shardKey = fn.assignShardKey((Object)((String)input.getKey()), (Object)((String)input.getValue()), numShards);
            generatedKeys.put(KV.of((Object)((String)input.getKey()), (Object)shardKey.getShardNumber()), shardKey);
        }
        fn = new FlinkStreamingPipelineTranslator.FlinkAutoBalancedShardKeyShardingFunction(numShards / 2, numShards * 2, (Coder)StringUtf8Coder.of());
        Collections.shuffle(inputs);
        for (KV input : inputs) {
            shardKey = fn.assignShardKey((Object)((String)input.getKey()), (Object)((String)input.getValue()), numShards);
            ShardedKey expectedShardKey = (ShardedKey)generatedKeys.get(KV.of((Object)((String)input.getKey()), (Object)shardKey.getShardNumber()));
            if (expectedShardKey == null) continue;
            MatcherAssert.assertThat((Object)shardKey, (Matcher)Matchers.equalTo((Object)expectedShardKey));
        }
    }

    @Test
    public void testAutoBalanceShardKeyCacheMaxSize() throws @UnknownKeyFor @NonNull @Initialized Exception {
        FlinkStreamingPipelineTranslator.FlinkAutoBalancedShardKeyShardingFunction fn = new FlinkStreamingPipelineTranslator.FlinkAutoBalancedShardKeyShardingFunction(2, 2, (Coder)StringUtf8Coder.of());
        for (int i = 0; i < 200; ++i) {
            fn.assignShardKey((Object)UUID.randomUUID().toString(), (Object)"one", 2);
        }
        MatcherAssert.assertThat((Object)fn.getCache().size(), (Matcher)Matchers.equalTo((Object)100));
    }
}

