/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkRunner;
import org.apache.beam.runners.flink.FlinkRunnerTestCompat;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.flink.client.program.OptimizerPlanEnvironment;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.ProgramInvocationException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Test;

public class FlinkRunnerTest
extends FlinkRunnerTestCompat {
    @Test
    public void testEnsureStdoutStdErrIsRestored() throws @UnknownKeyFor @NonNull @Initialized Exception {
        PackagedProgram packagedProgram = this.getPackagedProgram();
        OptimizerPlanEnvironment env = this.getOptimizerPlanEnvironment();
        try {
            this.getPipeline(env, packagedProgram);
            Assert.fail((String)"This should have failed to create the Flink Plan.");
        }
        catch (ProgramInvocationException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{StringContains.containsString((String)"System.out: (none)"), StringContains.containsString((String)"System.err: (none)")}));
        }
    }

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        FlinkPipelineOptions options = FlinkPipelineOptions.defaults();
        options.setRunner(NotExecutingFlinkRunner.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        p.apply((PTransform)GenerateSequence.from((long)0L));
        p.run();
    }

    private static class NotExecutingFlinkRunner
    extends FlinkRunner {
        protected NotExecutingFlinkRunner(@UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions options) {
            super(options);
        }

        public static @UnknownKeyFor @NonNull @Initialized NotExecutingFlinkRunner fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return new NotExecutingFlinkRunner((FlinkPipelineOptions)options.as(FlinkPipelineOptions.class));
        }

        public @UnknownKeyFor @NonNull @Initialized PipelineResult run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
            return null;
        }
    }
}

