/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.util.Collections;
import org.apache.beam.runners.flink.FlinkRunnerResult;
import org.apache.beam.sdk.PipelineResult;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.joda.time.Duration;
import org.junit.Test;

public class FlinkRunnerResultTest {
    @Test
    public void testPipelineResultReturnsDone() {
        FlinkRunnerResult result = new FlinkRunnerResult(Collections.emptyMap(), 100L);
        MatcherAssert.assertThat((Object)result.getState(), (Matcher)Is.is((Object)PipelineResult.State.DONE));
    }

    @Test
    public void testWaitUntilFinishReturnsDone() {
        FlinkRunnerResult result = new FlinkRunnerResult(Collections.emptyMap(), 100L);
        MatcherAssert.assertThat((Object)result.waitUntilFinish(), (Matcher)Is.is((Object)PipelineResult.State.DONE));
        MatcherAssert.assertThat((Object)result.waitUntilFinish(Duration.millis((long)100L)), (Matcher)Is.is((Object)PipelineResult.State.DONE));
    }

    @Test
    public void testCancelDoesNotThrowAnException() {
        FlinkRunnerResult result = new FlinkRunnerResult(Collections.emptyMap(), 100L);
        result.cancel();
        MatcherAssert.assertThat((Object)result.getState(), (Matcher)Is.is((Object)PipelineResult.State.DONE));
    }
}

