/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.BufferedElement;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.joda.time.Instant;

class BufferedElements {
    BufferedElements() {
    }

    static class Coder
    extends org.apache.beam.sdk.coders.Coder<BufferedElement> {
        private static final StringUtf8Coder STRING_CODER = StringUtf8Coder.of();
        private static final InstantCoder INSTANT_CODER = InstantCoder.of();
        private static final int ELEMENT_MAGIC_BYTE = 0;
        private static final int TIMER_MAGIC_BYTE = 1;
        private final org.apache.beam.sdk.coders.Coder<WindowedValue> elementCoder;
        private final org.apache.beam.sdk.coders.Coder<BoundedWindow> windowCoder;
        private final Object key;

        public Coder(org.apache.beam.sdk.coders.Coder<WindowedValue> elementCoder, org.apache.beam.sdk.coders.Coder<BoundedWindow> windowCoder, Object key) {
            this.elementCoder = elementCoder;
            this.windowCoder = windowCoder;
            this.key = key;
        }

        public void encode(BufferedElement value, OutputStream outStream) throws IOException {
            if (value instanceof Element) {
                outStream.write(0);
                this.elementCoder.encode((Object)((Element)value).element, outStream);
            } else if (value instanceof Timer) {
                outStream.write(1);
                Timer timer = (Timer)value;
                STRING_CODER.encode(timer.timerId, outStream);
                STRING_CODER.encode(timer.timerFamilyId, outStream);
                this.windowCoder.encode((Object)timer.window, outStream);
                INSTANT_CODER.encode(timer.timestamp, outStream);
                INSTANT_CODER.encode(timer.outputTimestamp, outStream);
                outStream.write(timer.timeDomain.ordinal());
            } else {
                throw new IllegalStateException("Unexpected element " + value);
            }
        }

        public BufferedElement decode(InputStream inStream) throws IOException {
            int firstByte = inStream.read();
            switch (firstByte) {
                case 0: {
                    return new Element((WindowedValue)this.elementCoder.decode(inStream));
                }
                case 1: {
                    return new Timer<Object>(STRING_CODER.decode(inStream), STRING_CODER.decode(inStream), this.key, (BoundedWindow)this.windowCoder.decode(inStream), INSTANT_CODER.decode(inStream), INSTANT_CODER.decode(inStream), TimeDomain.values()[inStream.read()]);
                }
            }
            throw new IllegalStateException("Unexpected byte while reading BufferedElement: " + firstByte);
        }

        public List<? extends org.apache.beam.sdk.coders.Coder<?>> getCoderArguments() {
            return Arrays.asList(this.elementCoder, this.windowCoder);
        }

        public void verifyDeterministic() {
        }
    }

    static final class Timer<KeyT>
    implements BufferedElement {
        private final String timerId;
        private final String timerFamilyId;
        private final BoundedWindow window;
        private final Instant timestamp;
        private final Instant outputTimestamp;
        private final TimeDomain timeDomain;
        private final KeyT key;

        Timer(String timerId, String timerFamilyId, KeyT key, BoundedWindow window, Instant timestamp, Instant outputTimestamp, TimeDomain timeDomain) {
            this.timerId = timerId;
            this.window = window;
            this.timestamp = timestamp;
            this.key = key;
            this.timeDomain = timeDomain;
            this.outputTimestamp = outputTimestamp;
            this.timerFamilyId = timerFamilyId;
        }

        public void processWith(DoFnRunner doFnRunner) {
            doFnRunner.onTimer(this.timerId, this.timerFamilyId, this.key, this.window, this.timestamp, this.outputTimestamp, this.timeDomain);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Timer timer = (Timer)o;
            return this.timerId.equals(timer.timerId) && this.window.equals(timer.window) && this.timestamp.equals((Object)timer.timestamp) && this.timeDomain == timer.timeDomain;
        }

        public int hashCode() {
            return Objects.hash(this.timerId, this.window, this.timestamp, this.timeDomain);
        }
    }

    static final class Element
    implements BufferedElement {
        private final WindowedValue element;

        Element(WindowedValue element) {
            this.element = element;
        }

        public void processWith(DoFnRunner doFnRunner) {
            doFnRunner.processElement(this.element);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Element element1 = (Element)o;
            return this.element.equals((Object)element1.element);
        }

        public int hashCode() {
            return Objects.hash(this.element);
        }
    }
}

