/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.types;

import javax.annotation.Nullable;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.translation.types.CoderTypeSerializer;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;

public class CoderTypeInformation<T>
extends TypeInformation<T>
implements AtomicType<T> {
    private final Coder<T> coder;
    @Nullable
    private final SerializablePipelineOptions pipelineOptions;

    public CoderTypeInformation(Coder<T> coder) {
        Preconditions.checkNotNull(coder);
        this.coder = coder;
        this.pipelineOptions = null;
    }

    private CoderTypeInformation(Coder<T> coder, PipelineOptions pipelineOptions) {
        Preconditions.checkNotNull(coder);
        this.coder = coder;
        this.pipelineOptions = new SerializablePipelineOptions(pipelineOptions);
    }

    public Coder<T> getCoder() {
        return this.coder;
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public Class<T> getTypeClass() {
        return this.coder.getEncodedTypeDescriptor().getRawType();
    }

    public boolean isKeyType() {
        return true;
    }

    public TypeSerializer<T> createSerializer(ExecutionConfig config) {
        return new CoderTypeSerializer<T>(this.coder, this.pipelineOptions);
    }

    public int getTotalFields() {
        return 2;
    }

    public CoderTypeInformation<T> withPipelineOptions(PipelineOptions pipelineOptions) {
        return new CoderTypeInformation<T>(this.getCoder(), pipelineOptions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CoderTypeInformation that = (CoderTypeInformation)((Object)o);
        return this.coder.equals(that.coder);
    }

    public int hashCode() {
        return this.coder.hashCode();
    }

    public boolean canEqual(Object obj) {
        return obj instanceof CoderTypeInformation;
    }

    public String toString() {
        return "CoderTypeInformation{coder=" + this.coder + '}';
    }

    public TypeComparator<T> createComparator(boolean sortOrderAscending, ExecutionConfig executionConfig) {
        throw new UnsupportedOperationException("Non-encoded values cannot be compared directly.");
    }
}

