/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.InMemoryMultimapSideInputView;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.flink.api.common.functions.BroadcastVariableInitializer;

public class SideInputInitializer<ViewT>
implements BroadcastVariableInitializer<WindowedValue<?>, Map<BoundedWindow, ViewT>> {
    PCollectionView<ViewT> view;

    public SideInputInitializer(PCollectionView<ViewT> view) {
        Preconditions.checkArgument((boolean)"beam:side_input:multimap:v1".equals(view.getViewFn().getMaterialization().getUrn()), (String)"This handler is only capable of dealing with %s materializations but was asked to handle %s for PCollectionView with tag %s.", (Object)"beam:side_input:multimap:v1", (Object)view.getViewFn().getMaterialization().getUrn(), (Object)view.getTagInternal().getId());
        this.view = view;
    }

    public Map<BoundedWindow, ViewT> initializeBroadcastVariable(Iterable<WindowedValue<?>> inputValues) {
        HashMap<BoundedWindow, List> partitionedElements = new HashMap<BoundedWindow, List>();
        for (WindowedValue<?> value : inputValues) {
            for (BoundedWindow window : value.getWindows()) {
                List windowedValues = partitionedElements.computeIfAbsent(window, k -> new ArrayList());
                windowedValues.add(value);
            }
        }
        HashMap<BoundedWindow, Object> resultMap = new HashMap<BoundedWindow, Object>();
        for (Map.Entry elements : partitionedElements.entrySet()) {
            ViewFn viewFn = this.view.getViewFn();
            Coder keyCoder = ((KvCoder)this.view.getCoderInternal()).getKeyCoder();
            resultMap.put((BoundedWindow)elements.getKey(), viewFn.apply((Object)InMemoryMultimapSideInputView.fromIterable((Coder)keyCoder, (Iterable)((List)elements.getValue()).stream().map(WindowedValue::getValue).collect(Collectors.toList()))));
        }
        return resultMap;
    }
}

