/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.SideInputHandler;
import org.apache.beam.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.runners.core.construction.graph.SideInputReference;
import org.apache.beam.runners.fnexecution.state.StateRequestHandlers;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public class FlinkStreamingSideInputHandlerFactory
implements StateRequestHandlers.SideInputHandlerFactory {
    private final Map<RunnerApi.ExecutableStagePayload.SideInputId, PCollectionView<?>> sideInputToCollection;
    private final SideInputHandler runnerHandler;

    public static FlinkStreamingSideInputHandlerFactory forStage(ExecutableStage stage, Map<RunnerApi.ExecutableStagePayload.SideInputId, PCollectionView<?>> viewMapping, SideInputHandler runnerHandler) {
        ImmutableMap.Builder sideInputBuilder = ImmutableMap.builder();
        for (SideInputReference sideInput : stage.getSideInputs()) {
            RunnerApi.ExecutableStagePayload.SideInputId sideInputId = RunnerApi.ExecutableStagePayload.SideInputId.newBuilder().setTransformId(sideInput.transform().getId()).setLocalName(sideInput.localName()).build();
            sideInputBuilder.put((Object)sideInputId, (Object)((PCollectionView)Preconditions.checkNotNull(viewMapping.get(sideInputId), (String)"No side input for %s/%s", (Object)sideInputId.getTransformId(), (Object)sideInputId.getLocalName())));
        }
        FlinkStreamingSideInputHandlerFactory factory = new FlinkStreamingSideInputHandlerFactory((Map<RunnerApi.ExecutableStagePayload.SideInputId, PCollectionView<?>>)sideInputBuilder.build(), runnerHandler);
        return factory;
    }

    private FlinkStreamingSideInputHandlerFactory(Map<RunnerApi.ExecutableStagePayload.SideInputId, PCollectionView<?>> sideInputToCollection, SideInputHandler runnerHandler) {
        this.sideInputToCollection = sideInputToCollection;
        this.runnerHandler = runnerHandler;
    }

    public <V, W extends BoundedWindow> StateRequestHandlers.IterableSideInputHandler<V, W> forIterableSideInput(String transformId, String sideInputId, final Coder<V> elementCoder, Coder<W> windowCoder) {
        final PCollectionView<?> collectionNode = this.sideInputToCollection.get(RunnerApi.ExecutableStagePayload.SideInputId.newBuilder().setTransformId(transformId).setLocalName(sideInputId).build());
        Preconditions.checkArgument((collectionNode != null ? 1 : 0) != 0, (String)"No side input for %s/%s", (Object)transformId, (Object)sideInputId);
        return new StateRequestHandlers.IterableSideInputHandler<V, W>(){

            public Iterable<V> get(W window) {
                return (Iterable)Preconditions.checkNotNull((Object)FlinkStreamingSideInputHandlerFactory.this.runnerHandler.getIterable(collectionNode, window), (Object)"Element processed by SDK before side input is ready");
            }

            public Coder<V> elementCoder() {
                return elementCoder;
            }
        };
    }

    public <K, V, W extends BoundedWindow> StateRequestHandlers.MultimapSideInputHandler<K, V, W> forMultimapSideInput(String transformId, String sideInputId, final KvCoder<K, V> elementCoder, Coder<W> windowCoder) {
        final PCollectionView<?> collectionNode = this.sideInputToCollection.get(RunnerApi.ExecutableStagePayload.SideInputId.newBuilder().setTransformId(transformId).setLocalName(sideInputId).build());
        Preconditions.checkArgument((collectionNode != null ? 1 : 0) != 0, (String)"No side input for %s/%s", (Object)transformId, (Object)sideInputId);
        return new StateRequestHandlers.MultimapSideInputHandler<K, V, W>(){

            public Iterable<V> get(K key, W window) {
                Iterable values = FlinkStreamingSideInputHandlerFactory.this.runnerHandler.getIterable(collectionNode, window);
                Object structuralK = this.keyCoder().structuralValue(key);
                ArrayList<Object> result = new ArrayList<Object>();
                for (KV kv : values) {
                    if (!structuralK.equals(this.keyCoder().structuralValue(kv.getKey()))) continue;
                    result.add(kv.getValue());
                }
                return Collections.unmodifiableList(result);
            }

            public Iterable<K> get(W window) {
                Iterable values = FlinkStreamingSideInputHandlerFactory.this.runnerHandler.getIterable(collectionNode, window);
                HashMap<Object, Object> result = new HashMap<Object, Object>();
                for (KV kv : values) {
                    result.putIfAbsent(this.keyCoder().structuralValue(kv.getKey()), kv.getKey());
                }
                return Collections.unmodifiableCollection(result.values());
            }

            public Coder<K> keyCoder() {
                return elementCoder.getKeyCoder();
            }

            public Coder<V> valueCoder() {
                return elementCoder.getValueCoder();
            }
        };
    }
}

