/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.runners.core.InMemoryMultimapSideInputView;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.flink.translation.functions.SideInputInitializer;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.flink.api.common.functions.RuntimeContext;

public class FlinkSideInputReader
implements SideInputReader {
    private final Map<TupleTag<?>, WindowingStrategy<?, ?>> sideInputs;
    private RuntimeContext runtimeContext;

    public FlinkSideInputReader(Map<PCollectionView<?>, WindowingStrategy<?, ?>> indexByView, RuntimeContext runtimeContext) {
        for (PCollectionView<?> pCollectionView : indexByView.keySet()) {
            Preconditions.checkArgument((boolean)"beam:side_input:multimap:v1".equals(pCollectionView.getViewFn().getMaterialization().getUrn()), (String)"This handler is only capable of dealing with %s materializations but was asked to handle %s for PCollectionView with tag %s.", (Object)"beam:side_input:multimap:v1", (Object)pCollectionView.getViewFn().getMaterialization().getUrn(), (Object)pCollectionView.getTagInternal().getId());
        }
        this.sideInputs = new HashMap();
        for (Map.Entry entry : indexByView.entrySet()) {
            this.sideInputs.put(((PCollectionView)entry.getKey()).getTagInternal(), (WindowingStrategy)entry.getValue());
        }
        this.runtimeContext = runtimeContext;
    }

    @Nullable
    public <T> T get(PCollectionView<T> view, BoundedWindow window) {
        Preconditions.checkNotNull(view, (Object)"View passed to sideInput cannot be null");
        TupleTag tag = view.getTagInternal();
        Preconditions.checkNotNull(this.sideInputs.get(tag), (Object)("Side input for " + view + " not available."));
        Map sideInputs = (Map)this.runtimeContext.getBroadcastVariableWithInitializer(tag.getId(), new SideInputInitializer<T>(view));
        Object result = sideInputs.get(window);
        if (result == null) {
            ViewFn viewFn = view.getViewFn();
            result = viewFn.apply((Object)InMemoryMultimapSideInputView.empty());
        }
        return (T)result;
    }

    public <T> boolean contains(PCollectionView<T> view) {
        return this.sideInputs.containsKey(view.getTagInternal());
    }

    public boolean isEmpty() {
        return this.sideInputs.isEmpty();
    }
}

