/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.extensions.metrics;

import java.util.Collections;
import java.util.List;
import org.apache.beam.runners.extensions.metrics.MetricsHttpSink;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;

public class MetricsHttpSinkTest {
    @Test
    public void testSerializerWithCommittedSupported() throws Exception {
        CustomMetricQueryResults metricQueryResults = new CustomMetricQueryResults(true);
        MetricsHttpSink metricsHttpSink = new MetricsHttpSink(PipelineOptionsFactory.create());
        String serializeMetrics = metricsHttpSink.serializeMetrics((MetricQueryResults)metricQueryResults);
        Assert.assertEquals((String)"Error in serialization", (Object)"{\"counters\":[{\"attempted\":20,\"committed\":10,\"name\":{\"name\":\"n1\",\"namespace\":\"ns1\"},\"step\":\"s1\"}],\"distributions\":[{\"attempted\":{\"count\":4,\"max\":9,\"mean\":6.25,\"min\":3,\"sum\":25},\"committed\":{\"count\":2,\"max\":8,\"mean\":5.0,\"min\":5,\"sum\":10},\"name\":{\"name\":\"n2\",\"namespace\":\"ns1\"},\"step\":\"s2\"}],\"gauges\":[{\"attempted\":{\"timestamp\":\"1970-01-01T00:00:00.000Z\",\"value\":120},\"committed\":{\"timestamp\":\"1970-01-01T00:00:00.000Z\",\"value\":100},\"name\":{\"name\":\"n3\",\"namespace\":\"ns1\"},\"step\":\"s3\"}]}", (Object)serializeMetrics);
    }

    @Test
    public void testSerializerWithCommittedUnSupported() throws Exception {
        CustomMetricQueryResults metricQueryResults = new CustomMetricQueryResults(false);
        MetricsHttpSink metricsHttpSink = new MetricsHttpSink(PipelineOptionsFactory.create());
        String serializeMetrics = metricsHttpSink.serializeMetrics((MetricQueryResults)metricQueryResults);
        Assert.assertEquals((String)"Error in serialization", (Object)"{\"counters\":[{\"attempted\":20,\"name\":{\"name\":\"n1\",\"namespace\":\"ns1\"},\"step\":\"s1\"}],\"distributions\":[{\"attempted\":{\"count\":4,\"max\":9,\"mean\":6.25,\"min\":3,\"sum\":25},\"name\":{\"name\":\"n2\",\"namespace\":\"ns1\"},\"step\":\"s2\"}],\"gauges\":[{\"attempted\":{\"timestamp\":\"1970-01-01T00:00:00.000Z\",\"value\":120},\"name\":{\"name\":\"n3\",\"namespace\":\"ns1\"},\"step\":\"s3\"}]}", (Object)serializeMetrics);
    }

    private static class CustomMetricQueryResults
    implements MetricQueryResults {
        private final boolean isCommittedSupported;

        private CustomMetricQueryResults(boolean isCommittedSupported) {
            this.isCommittedSupported = isCommittedSupported;
        }

        public List<MetricResult<Long>> getCounters() {
            return Collections.singletonList(new MetricResult<Long>(){

                public MetricName getName() {
                    return MetricName.named((String)"ns1", (String)"n1");
                }

                public String getStep() {
                    return "s1";
                }

                public Long getCommitted() {
                    if (!isCommittedSupported) {
                        throw new UnsupportedOperationException("This runner does not currently support committed metrics results. Please use 'attempted' instead.");
                    }
                    return 10L;
                }

                public Long getAttempted() {
                    return 20L;
                }
            });
        }

        public List<MetricResult<DistributionResult>> getDistributions() {
            return Collections.singletonList(new MetricResult<DistributionResult>(){

                public MetricName getName() {
                    return MetricName.named((String)"ns1", (String)"n2");
                }

                public String getStep() {
                    return "s2";
                }

                public DistributionResult getCommitted() {
                    if (!isCommittedSupported) {
                        throw new UnsupportedOperationException("This runner does not currently support committed metrics results. Please use 'attempted' instead.");
                    }
                    return DistributionResult.create((long)10L, (long)2L, (long)5L, (long)8L);
                }

                public DistributionResult getAttempted() {
                    return DistributionResult.create((long)25L, (long)4L, (long)3L, (long)9L);
                }
            });
        }

        public List<MetricResult<GaugeResult>> getGauges() {
            return Collections.singletonList(new MetricResult<GaugeResult>(){

                public MetricName getName() {
                    return MetricName.named((String)"ns1", (String)"n3");
                }

                public String getStep() {
                    return "s3";
                }

                public GaugeResult getCommitted() {
                    if (!isCommittedSupported) {
                        throw new UnsupportedOperationException("This runner does not currently support committed metrics results. Please use 'attempted' instead.");
                    }
                    return GaugeResult.create((long)100L, (Instant)new Instant(0L));
                }

                public GaugeResult getAttempted() {
                    return GaugeResult.create((long)120L, (Instant)new Instant(0L));
                }
            });
        }
    }
}

