/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.extensions.metrics;

import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.joda.time.Instant;

class CustomMetricQueryResults
extends MetricQueryResults {
    private final boolean isCommittedSupported;
    public static final String NAMESPACE = "ns1";

    CustomMetricQueryResults(boolean isCommittedSupported) {
        this.isCommittedSupported = isCommittedSupported;
    }

    private <T> List<MetricResult<T>> makeResults(String step, String name, T committed, T attempted) {
        MetricName metricName = MetricName.named((String)NAMESPACE, (String)name);
        MetricKey key = MetricKey.create((String)step, (MetricName)metricName);
        return Collections.singletonList(this.isCommittedSupported ? MetricResult.create((MetricKey)key, committed, attempted) : MetricResult.attempted((MetricKey)key, attempted));
    }

    public List<MetricResult<Long>> getCounters() {
        return this.makeResults("s1", "n1", 10L, 20L);
    }

    public List<MetricResult<DistributionResult>> getDistributions() {
        return this.makeResults("s2", "n2", DistributionResult.create((long)10L, (long)2L, (long)5L, (long)8L), DistributionResult.create((long)25L, (long)4L, (long)3L, (long)9L));
    }

    public List<MetricResult<GaugeResult>> getGauges() {
        return this.makeResults("s3", "n3", GaugeResult.create((long)100L, (Instant)new Instant(345862800L)), GaugeResult.create((long)120L, (Instant)new Instant(345862800L)));
    }
}

