/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.extensions.metrics;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricsOptions;
import org.apache.beam.sdk.metrics.MetricsSink;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class MetricsGraphiteSink
implements MetricsSink {
    private static final @UnknownKeyFor @NonNull @Initialized Charset UTF_8 = Charset.forName("UTF-8");
    private static final @UnknownKeyFor @NonNull @Initialized Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private static final @UnknownKeyFor @NonNull @Initialized String SPACE_REPLACEMENT = "_";
    private final @UnknownKeyFor @NonNull @Initialized String address;
    private final @UnknownKeyFor @NonNull @Initialized int port;
    private final @UnknownKeyFor @NonNull @Initialized Charset charset;

    public MetricsGraphiteSink(@UnknownKeyFor @NonNull @Initialized MetricsOptions pipelineOptions) {
        this.address = pipelineOptions.getMetricsGraphiteHost();
        this.port = pipelineOptions.getMetricsGraphitePort();
        this.charset = UTF_8;
    }

    public void writeMetrics(@UnknownKeyFor @NonNull @Initialized MetricQueryResults metricQueryResults) throws @UnknownKeyFor @NonNull @Initialized Exception {
        long metricTimestamp = System.currentTimeMillis() / 1000L;
        Socket socket = new Socket(InetAddress.getByName(this.address), this.port);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), this.charset));
        StringBuilder messagePayload = new StringBuilder();
        Iterable counters = metricQueryResults.getCounters();
        Iterable gauges = metricQueryResults.getGauges();
        Iterable distributions = metricQueryResults.getDistributions();
        for (MetricResult counter : counters) {
            messagePayload.append(new CounterMetricMessage(counter, "value", metricTimestamp).toString());
        }
        for (MetricResult gauge : gauges) {
            messagePayload.append(new GaugeMetricMessage(gauge, "value").toString());
        }
        for (MetricResult distribution : distributions) {
            messagePayload.append(new DistributionMetricMessage((MetricResult<DistributionResult>)distribution, "min", metricTimestamp).toString());
            messagePayload.append(new DistributionMetricMessage((MetricResult<DistributionResult>)distribution, "max", metricTimestamp).toString());
            messagePayload.append(new DistributionMetricMessage((MetricResult<DistributionResult>)distribution, "count", metricTimestamp).toString());
            messagePayload.append(new DistributionMetricMessage((MetricResult<DistributionResult>)distribution, "sum", metricTimestamp).toString());
            messagePayload.append(new DistributionMetricMessage((MetricResult<DistributionResult>)distribution, "mean", metricTimestamp).toString());
        }
        writer.write(messagePayload.toString());
        writer.flush();
        writer.close();
        socket.close();
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized String createNormalizedMetricName(@UnknownKeyFor @NonNull @Initialized MetricResult<T> metric, @UnknownKeyFor @NonNull @Initialized String metricType, @UnknownKeyFor @NonNull @Initialized String valueType, @UnknownKeyFor @NonNull @Initialized CommittedOrAttemped committedOrAttemped) {
        String metricName = String.format("beam.%s.%s.%s.%s.%s.%s", new Object[]{metricType, metric.getName().getNamespace(), metric.getName().getName(), metric.getKey().stepName(), committedOrAttemped, valueType});
        return WHITESPACE.matcher(metricName).replaceAll(SPACE_REPLACEMENT);
    }

    private static enum CommittedOrAttemped {
        COMMITTED("committed"),
        ATTEMPTED("attempted");

        private final @UnknownKeyFor @NonNull @Initialized String committedOrAttempted;

        private CommittedOrAttemped(String committedOrAttempted) {
            this.committedOrAttempted = committedOrAttempted;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.committedOrAttempted;
        }
    }

    private static class DistributionMetricMessage
    extends MetricMessage {
        private @UnknownKeyFor @NonNull @Initialized String valueType;
        private @UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized DistributionResult> distribution;
        private @UnknownKeyFor @NonNull @Initialized long metricTimestamp;

        public DistributionMetricMessage(@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized DistributionResult> distribution, @UnknownKeyFor @NonNull @Initialized String valueType, @UnknownKeyFor @NonNull @Initialized long metricTimestamp) {
            this.valueType = valueType;
            this.distribution = distribution;
            this.metricTimestamp = metricTimestamp;
        }

        @Override
        @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="\\n is part of graphite protocol")
        protected @UnknownKeyFor @NonNull @Initialized String createCommittedMessage() {
            Number value = null;
            switch (this.valueType) {
                case "min": {
                    value = ((DistributionResult)this.distribution.getCommitted()).getMin();
                    break;
                }
                case "max": {
                    value = ((DistributionResult)this.distribution.getCommitted()).getMax();
                    break;
                }
                case "count": {
                    value = ((DistributionResult)this.distribution.getCommitted()).getCount();
                    break;
                }
                case "sum": {
                    value = ((DistributionResult)this.distribution.getCommitted()).getSum();
                    break;
                }
                case "mean": {
                    value = ((DistributionResult)this.distribution.getCommitted()).getMean();
                    break;
                }
            }
            String metricMessage = String.format(Locale.US, "%s %s %s\n", MetricsGraphiteSink.createNormalizedMetricName(this.distribution, "distribution", this.valueType, CommittedOrAttemped.COMMITTED), value, this.metricTimestamp);
            return metricMessage;
        }

        @Override
        @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="\\n is part of graphite protocol")
        protected @UnknownKeyFor @NonNull @Initialized String createAttemptedMessage() {
            Number value = null;
            switch (this.valueType) {
                case "min": {
                    value = ((DistributionResult)this.distribution.getAttempted()).getMin();
                    break;
                }
                case "max": {
                    value = ((DistributionResult)this.distribution.getAttempted()).getMax();
                    break;
                }
                case "count": {
                    value = ((DistributionResult)this.distribution.getAttempted()).getCount();
                    break;
                }
                case "sum": {
                    value = ((DistributionResult)this.distribution.getAttempted()).getSum();
                    break;
                }
                case "mean": {
                    value = ((DistributionResult)this.distribution.getAttempted()).getMean();
                    break;
                }
            }
            String metricMessage = String.format(Locale.US, "%s %s %s\n", MetricsGraphiteSink.createNormalizedMetricName(this.distribution, "distribution", this.valueType, CommittedOrAttemped.ATTEMPTED), value, this.metricTimestamp);
            return metricMessage;
        }
    }

    private static class GaugeMetricMessage
    extends MetricMessage {
        private @UnknownKeyFor @NonNull @Initialized String valueType;
        private @UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized GaugeResult> gauge;

        private GaugeMetricMessage(@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized GaugeResult> gauge, @UnknownKeyFor @NonNull @Initialized String valueType) {
            this.valueType = valueType;
            this.gauge = gauge;
        }

        @Override
        @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="\\n is part of graphite protocol")
        protected @UnknownKeyFor @NonNull @Initialized String createCommittedMessage() {
            String metricMessage = String.format(Locale.US, "%s %s %s\n", MetricsGraphiteSink.createNormalizedMetricName(this.gauge, "gauge", this.valueType, CommittedOrAttemped.COMMITTED), ((GaugeResult)this.gauge.getCommitted()).getValue(), ((GaugeResult)this.gauge.getCommitted()).getTimestamp().getMillis() / 1000L);
            return metricMessage;
        }

        @Override
        @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="\\n is part of graphite protocol")
        protected @UnknownKeyFor @NonNull @Initialized String createAttemptedMessage() {
            String metricMessage = String.format(Locale.US, "%s %s %s\n", MetricsGraphiteSink.createNormalizedMetricName(this.gauge, "gauge", this.valueType, CommittedOrAttemped.ATTEMPTED), ((GaugeResult)this.gauge.getAttempted()).getValue(), ((GaugeResult)this.gauge.getAttempted()).getTimestamp().getMillis() / 1000L);
            return metricMessage;
        }
    }

    private static class CounterMetricMessage
    extends MetricMessage {
        private @UnknownKeyFor @NonNull @Initialized String valueType;
        private @UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized Long> counter;
        private @UnknownKeyFor @NonNull @Initialized long metricTimestamp;

        private CounterMetricMessage(@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized Long> counter, @UnknownKeyFor @NonNull @Initialized String valueType, @UnknownKeyFor @NonNull @Initialized long metricTimestamp) {
            this.valueType = valueType;
            this.counter = counter;
            this.metricTimestamp = metricTimestamp;
        }

        @Override
        @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="\\n is part of graphite protocol")
        protected @UnknownKeyFor @NonNull @Initialized String createCommittedMessage() {
            String metricMessage = String.format(Locale.US, "%s %s %s\n", MetricsGraphiteSink.createNormalizedMetricName(this.counter, "counter", this.valueType, CommittedOrAttemped.COMMITTED), this.counter.getCommitted(), this.metricTimestamp);
            return metricMessage;
        }

        @Override
        @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="\\n is part of graphite protocol")
        protected @UnknownKeyFor @NonNull @Initialized String createAttemptedMessage() {
            String metricMessage = String.format(Locale.US, "%s %s %s\n", MetricsGraphiteSink.createNormalizedMetricName(this.counter, "counter", this.valueType, CommittedOrAttemped.ATTEMPTED), this.counter.getAttempted(), this.metricTimestamp);
            return metricMessage;
        }
    }

    private static abstract class MetricMessage {
        private MetricMessage() {
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            StringBuilder messagePayload;
            block2: {
                messagePayload = new StringBuilder();
                try {
                    messagePayload.append(this.createCommittedMessage());
                }
                catch (UnsupportedOperationException e) {
                    if (e.getMessage().contains("committed metrics")) break block2;
                    throw e;
                }
            }
            messagePayload.append(this.createAttemptedMessage());
            return messagePayload.toString();
        }

        protected abstract @UnknownKeyFor @NonNull @Initialized String createCommittedMessage();

        protected abstract @UnknownKeyFor @NonNull @Initialized String createAttemptedMessage();
    }
}

