/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.extensions.metrics;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

class NetworkMockServer {
    private final int port;
    private ServerSocket serverSocket;
    private ServerThread thread;
    private CountDownLatch countDownLatch;
    private Collection<String> messages = new CopyOnWriteArrayList<String>();

    public NetworkMockServer(int port) {
        this.port = port;
    }

    public void setCountDownLatch(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    public NetworkMockServer start() throws IOException {
        this.serverSocket = new ServerSocket(this.port);
        this.thread = new ServerThread(this.serverSocket, this.messages);
        this.thread.start();
        return this;
    }

    public void stop() throws IOException {
        this.thread.shutdown();
        this.serverSocket.close();
    }

    public Collection<String> getMessages() {
        return this.messages;
    }

    public void clear() {
        this.messages.clear();
    }

    private class ServerThread
    extends Thread {
        private final Collection<String> messages;
        private final AtomicBoolean done = new AtomicBoolean(false);
        private final ServerSocket server;

        public ServerThread(ServerSocket server, Collection<String> messages) {
            this.messages = messages;
            this.server = server;
            this.setName("network-mock-server");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.done.get()) {
                try {
                    Socket s = this.server.accept();
                    ServerThread serverThread = this;
                    synchronized (serverThread) {
                        InputStream is = s.getInputStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
                        try {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                this.messages.add(line);
                            }
                        }
                        finally {
                            NetworkMockServer.this.countDownLatch.countDown();
                            s.close();
                        }
                    }
                }
                catch (IOException e) {
                    if (this.done.get()) continue;
                    throw new RuntimeException(e);
                }
            }
        }

        public void shutdown() {
            this.done.set(true);
        }
    }
}

