/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.extensions.metrics;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.concurrent.CountDownLatch;
import org.apache.beam.runners.extensions.metrics.CustomMetricQueryResults;
import org.apache.beam.runners.extensions.metrics.MetricsGraphiteSink;
import org.apache.beam.runners.extensions.metrics.NetworkMockServer;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricsOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MetricsGraphiteSinkTest {
    private static NetworkMockServer graphiteServer;
    private static int port;

    @BeforeClass
    public static void beforeClass() throws IOException, InterruptedException {
        ServerSocket serverSocket = new ServerSocket(0);
        port = serverSocket.getLocalPort();
        serverSocket.close();
        graphiteServer = new NetworkMockServer(port);
        graphiteServer.clear();
        graphiteServer.start();
    }

    @Before
    public void before() {
        graphiteServer.clear();
    }

    @AfterClass
    public static void afterClass() throws IOException {
        graphiteServer.stop();
    }

    @Test
    public void testWriteMetricsWithCommittedSupported() throws Exception {
        CustomMetricQueryResults metricQueryResults = new CustomMetricQueryResults(true);
        MetricsOptions pipelineOptions = (MetricsOptions)PipelineOptionsFactory.create().as(MetricsOptions.class);
        pipelineOptions.setMetricsGraphitePort(Integer.valueOf(port));
        pipelineOptions.setMetricsGraphiteHost("127.0.0.1");
        MetricsGraphiteSink metricsGraphiteSink = new MetricsGraphiteSink(pipelineOptions);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        graphiteServer.setCountDownLatch(countDownLatch);
        metricsGraphiteSink.writeMetrics((MetricQueryResults)metricQueryResults);
        countDownLatch.await();
        String join = String.join((CharSequence)"\n", graphiteServer.getMessages());
        String regexpr = "beam.counter.ns1.n1.s1.committed.value 10 [0-9]+\\nbeam.counter.ns1.n1.s1.attempted.value 20 [0-9]+\\nbeam.gauge.ns1.n3.s3.committed.value 100 [0-9]+\\nbeam.gauge.ns1.n3.s3.attempted.value 120 [0-9]+\\nbeam.distribution.ns1.n2.s2.committed.min 5 [0-9]+\\nbeam.distribution.ns1.n2.s2.attempted.min 3 [0-9]+\\nbeam.distribution.ns1.n2.s2.committed.max 8 [0-9]+\\nbeam.distribution.ns1.n2.s2.attempted.max 9 [0-9]+\\nbeam.distribution.ns1.n2.s2.committed.count 2 [0-9]+\\nbeam.distribution.ns1.n2.s2.attempted.count 4 [0-9]+\\nbeam.distribution.ns1.n2.s2.committed.sum 10 [0-9]+\\nbeam.distribution.ns1.n2.s2.attempted.sum 25 [0-9]+\\nbeam.distribution.ns1.n2.s2.committed.mean 5.0 [0-9]+\\nbeam.distribution.ns1.n2.s2.attempted.mean 6.25 [0-9]+";
        Assert.assertTrue((boolean)join.matches(regexpr));
    }

    @Test
    public void testWriteMetricsWithCommittedUnSupported() throws Exception {
        CustomMetricQueryResults metricQueryResults = new CustomMetricQueryResults(false);
        MetricsOptions pipelineOptions = (MetricsOptions)PipelineOptionsFactory.create().as(MetricsOptions.class);
        pipelineOptions.setMetricsGraphitePort(Integer.valueOf(port));
        pipelineOptions.setMetricsGraphiteHost("127.0.0.1");
        MetricsGraphiteSink metricsGraphiteSink = new MetricsGraphiteSink(pipelineOptions);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        graphiteServer.setCountDownLatch(countDownLatch);
        metricsGraphiteSink.writeMetrics((MetricQueryResults)metricQueryResults);
        countDownLatch.await();
        String join = String.join((CharSequence)"\n", graphiteServer.getMessages());
        String regexpr = "beam.counter.ns1.n1.s1.attempted.value 20 [0-9]+\\nbeam.gauge.ns1.n3.s3.attempted.value 120 [0-9]+\\nbeam.distribution.ns1.n2.s2.attempted.min 3 [0-9]+\\nbeam.distribution.ns1.n2.s2.attempted.max 9 [0-9]+\\nbeam.distribution.ns1.n2.s2.attempted.count 4 [0-9]+\\nbeam.distribution.ns1.n2.s2.attempted.sum 25 [0-9]+\\nbeam.distribution.ns1.n2.s2.attempted.mean 6.25 [0-9]+";
        Assert.assertTrue((boolean)join.matches(regexpr));
    }
}

