/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.extensions.metrics;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.xml.ws.http.HTTPException;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricsOptions;
import org.apache.beam.sdk.metrics.MetricsSink;

public class MetricsHttpSink
implements MetricsSink {
    private final String urlString;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public MetricsHttpSink(MetricsOptions pipelineOptions) {
        this.urlString = pipelineOptions.getMetricsHttpSinkUrl();
    }

    @Experimental(value=Experimental.Kind.METRICS)
    public void writeMetrics(MetricQueryResults metricQueryResults) throws Exception {
        URL url = new URL(this.urlString);
        String metrics = this.serializeMetrics(metricQueryResults);
        byte[] postData = metrics.getBytes(StandardCharsets.UTF_8);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("charset", "utf-8");
        connection.setRequestProperty("Content-Length", Integer.toString(postData.length));
        connection.setUseCaches(false);
        try (DataOutputStream connectionOuputStream = new DataOutputStream(connection.getOutputStream());){
            connectionOuputStream.write(postData);
        }
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            throw new HTTPException(responseCode);
        }
    }

    private String serializeMetrics(MetricQueryResults metricQueryResults) throws Exception {
        String result;
        JodaModule module = new JodaModule();
        module.addSerializer((JsonSerializer)new MetricNameSerializer(MetricName.class));
        module.addSerializer((JsonSerializer)new MetricKeySerializer(MetricKey.class));
        module.addSerializer((JsonSerializer)new MetricResultSerializer(MetricResult.class));
        this.objectMapper.registerModule((Module)module);
        this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        SimpleBeanPropertyFilter filter = SimpleBeanPropertyFilter.serializeAll();
        SimpleFilterProvider filterProvider = new SimpleFilterProvider();
        filterProvider.addFilter("committedMetrics", filter);
        this.objectMapper.setFilterProvider((FilterProvider)filterProvider);
        try {
            result = this.objectMapper.writeValueAsString((Object)metricQueryResults);
        }
        catch (JsonMappingException exception) {
            if (exception.getCause() instanceof UnsupportedOperationException && exception.getCause().getMessage().contains("committed metrics")) {
                filterProvider.removeFilter("committedMetrics");
                filter = SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"committed"});
                filterProvider.addFilter("committedMetrics", filter);
                result = this.objectMapper.writeValueAsString((Object)metricQueryResults);
            }
            throw exception;
        }
        return result;
    }

    public static class MetricResultSerializer
    extends StdSerializer<MetricResult> {
        private final MetricKeySerializer keySerializer = new MetricKeySerializer(MetricKey.class);

        public MetricResultSerializer(Class<MetricResult> t) {
            super(t);
        }

        public void serialize(MetricResult value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeObjectField("attempted", value.getAttempted());
            if (value.hasCommitted()) {
                gen.writeObjectField("committed", value.getCommitted());
            }
            this.keySerializer.inline(value.getKey(), gen, provider);
            gen.writeEndObject();
        }
    }

    public static class MetricKeySerializer
    extends StdSerializer<MetricKey> {
        public MetricKeySerializer(Class<MetricKey> t) {
            super(t);
        }

        public void inline(MetricKey value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeObjectField("name", (Object)value.metricName());
            gen.writeObjectField("step", (Object)value.stepName());
        }

        public void serialize(MetricKey value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            this.inline(value, gen, provider);
            gen.writeEndObject();
        }
    }

    public static class MetricNameSerializer
    extends StdSerializer<MetricName> {
        public MetricNameSerializer(Class<MetricName> t) {
            super(t);
        }

        public void serialize(MetricName value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeObjectField("name", (Object)value.name());
            gen.writeObjectField("namespace", (Object)value.namespace());
            gen.writeEndObject();
        }
    }
}

