/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.extensions.metrics;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricsOptions;
import org.apache.beam.sdk.metrics.MetricsSink;

public class MetricsGraphiteSink
implements MetricsSink {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private static final String SPACE_REPLACEMENT = "_";
    private final String address;
    private final int port;
    private final Charset charset;

    public MetricsGraphiteSink(MetricsOptions pipelineOptions) {
        this.address = pipelineOptions.getMetricsGraphiteHost();
        this.port = pipelineOptions.getMetricsGraphitePort();
        this.charset = UTF_8;
    }

    @Experimental(value=Experimental.Kind.METRICS)
    public void writeMetrics(MetricQueryResults metricQueryResults) throws Exception {
        long metricTimestamp = System.currentTimeMillis() / 1000L;
        Socket socket = new Socket(InetAddress.getByName(this.address), this.port);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), this.charset));
        StringBuilder messagePayload = new StringBuilder();
        Iterable counters = metricQueryResults.getCounters();
        Iterable gauges = metricQueryResults.getGauges();
        Iterable distributions = metricQueryResults.getDistributions();
        for (MetricResult counter : counters) {
            messagePayload.append(new CounterMetricMessage(counter, "value", metricTimestamp).toString());
        }
        for (MetricResult gauge : gauges) {
            messagePayload.append(new GaugeMetricMessage(gauge, "value").toString());
        }
        for (MetricResult distribution : distributions) {
            messagePayload.append(new DistributionMetricMessage((MetricResult<DistributionResult>)distribution, "min", metricTimestamp).toString());
            messagePayload.append(new DistributionMetricMessage((MetricResult<DistributionResult>)distribution, "max", metricTimestamp).toString());
            messagePayload.append(new DistributionMetricMessage((MetricResult<DistributionResult>)distribution, "count", metricTimestamp).toString());
            messagePayload.append(new DistributionMetricMessage((MetricResult<DistributionResult>)distribution, "sum", metricTimestamp).toString());
            messagePayload.append(new DistributionMetricMessage((MetricResult<DistributionResult>)distribution, "mean", metricTimestamp).toString());
        }
        writer.write(messagePayload.toString());
        writer.flush();
        writer.close();
        socket.close();
    }

    private static <T> String createNormalizedMetricName(MetricResult<T> metric, String metricType, String valueType, CommittedOrAttemped committedOrAttemped) {
        String metricName = String.format("beam.%s.%s.%s.%s.%s", new Object[]{metricType, metric.getName().getNamespace(), metric.getName().getName(), committedOrAttemped, valueType});
        return WHITESPACE.matcher(metricName).replaceAll(SPACE_REPLACEMENT);
    }

    private static enum CommittedOrAttemped {
        COMMITTED("committed"),
        ATTEMPTED("attempted");

        private final String committedOrAttempted;

        private CommittedOrAttemped(String committedOrAttempted) {
            this.committedOrAttempted = committedOrAttempted;
        }

        public String toString() {
            return this.committedOrAttempted;
        }
    }

    private static class DistributionMetricMessage
    extends MetricMessage {
        private String valueType;
        private MetricResult<DistributionResult> distribution;
        private long metricTimestamp;

        public DistributionMetricMessage(MetricResult<DistributionResult> distribution, String valueType, long metricTimestamp) {
            this.valueType = valueType;
            this.distribution = distribution;
            this.metricTimestamp = metricTimestamp;
        }

        @Override
        @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="\\n is part of graphite protocol")
        protected String createCommittedMessage() {
            Number value = null;
            switch (this.valueType) {
                case "min": {
                    value = ((DistributionResult)this.distribution.getCommitted()).getMin();
                    break;
                }
                case "max": {
                    value = ((DistributionResult)this.distribution.getCommitted()).getMax();
                    break;
                }
                case "count": {
                    value = ((DistributionResult)this.distribution.getCommitted()).getCount();
                    break;
                }
                case "sum": {
                    value = ((DistributionResult)this.distribution.getCommitted()).getSum();
                    break;
                }
                case "mean": {
                    value = ((DistributionResult)this.distribution.getCommitted()).getMean();
                    break;
                }
            }
            String metricMessage = String.format(Locale.US, "%s %s %s\n", MetricsGraphiteSink.createNormalizedMetricName(this.distribution, "distribution", this.valueType, CommittedOrAttemped.COMMITTED), value, this.metricTimestamp);
            return metricMessage;
        }

        @Override
        @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="\\n is part of graphite protocol")
        protected String createAttemptedMessage() {
            Number value = null;
            switch (this.valueType) {
                case "min": {
                    value = ((DistributionResult)this.distribution.getAttempted()).getMin();
                    break;
                }
                case "max": {
                    value = ((DistributionResult)this.distribution.getAttempted()).getMax();
                    break;
                }
                case "count": {
                    value = ((DistributionResult)this.distribution.getAttempted()).getCount();
                    break;
                }
                case "sum": {
                    value = ((DistributionResult)this.distribution.getAttempted()).getSum();
                    break;
                }
                case "mean": {
                    value = ((DistributionResult)this.distribution.getAttempted()).getMean();
                    break;
                }
            }
            String metricMessage = String.format(Locale.US, "%s %s %s\n", MetricsGraphiteSink.createNormalizedMetricName(this.distribution, "distribution", this.valueType, CommittedOrAttemped.ATTEMPTED), value, this.metricTimestamp);
            return metricMessage;
        }
    }

    private static class GaugeMetricMessage
    extends MetricMessage {
        private String valueType;
        private MetricResult<GaugeResult> gauge;

        private GaugeMetricMessage(MetricResult<GaugeResult> gauge, String valueType) {
            this.valueType = valueType;
            this.gauge = gauge;
        }

        @Override
        @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="\\n is part of graphite protocol")
        protected String createCommittedMessage() {
            String metricMessage = String.format(Locale.US, "%s %s %s\n", MetricsGraphiteSink.createNormalizedMetricName(this.gauge, "gauge", this.valueType, CommittedOrAttemped.COMMITTED), ((GaugeResult)this.gauge.getCommitted()).getValue(), ((GaugeResult)this.gauge.getCommitted()).getTimestamp().getMillis() / 1000L);
            return metricMessage;
        }

        @Override
        @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="\\n is part of graphite protocol")
        protected String createAttemptedMessage() {
            String metricMessage = String.format(Locale.US, "%s %s %s\n", MetricsGraphiteSink.createNormalizedMetricName(this.gauge, "gauge", this.valueType, CommittedOrAttemped.ATTEMPTED), ((GaugeResult)this.gauge.getAttempted()).getValue(), ((GaugeResult)this.gauge.getAttempted()).getTimestamp().getMillis() / 1000L);
            return metricMessage;
        }
    }

    private static class CounterMetricMessage
    extends MetricMessage {
        private String valueType;
        private MetricResult<Long> counter;
        private long metricTimestamp;

        private CounterMetricMessage(MetricResult<Long> counter, String valueType, long metricTimestamp) {
            this.valueType = valueType;
            this.counter = counter;
            this.metricTimestamp = metricTimestamp;
        }

        @Override
        @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="\\n is part of graphite protocol")
        protected String createCommittedMessage() {
            String metricMessage = String.format(Locale.US, "%s %s %s\n", MetricsGraphiteSink.createNormalizedMetricName(this.counter, "counter", this.valueType, CommittedOrAttemped.COMMITTED), this.counter.getCommitted(), this.metricTimestamp);
            return metricMessage;
        }

        @Override
        @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="\\n is part of graphite protocol")
        protected String createAttemptedMessage() {
            String metricMessage = String.format(Locale.US, "%s %s %s\n", MetricsGraphiteSink.createNormalizedMetricName(this.counter, "counter", this.valueType, CommittedOrAttemped.ATTEMPTED), this.counter.getAttempted(), this.metricTimestamp);
            return metricMessage;
        }
    }

    private static abstract class MetricMessage {
        private MetricMessage() {
        }

        public String toString() {
            StringBuilder messagePayload;
            block2: {
                messagePayload = new StringBuilder();
                try {
                    messagePayload.append(this.createCommittedMessage());
                }
                catch (UnsupportedOperationException e) {
                    if (e.getMessage().contains("committed metrics")) break block2;
                    throw e;
                }
            }
            messagePayload.append(this.createAttemptedMessage());
            return messagePayload.toString();
        }

        protected abstract String createCommittedMessage();

        protected abstract String createAttemptedMessage();
    }
}

