/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.it.testcontainers;

import java.util.concurrent.Callable;
import org.apache.beam.it.common.ResourceManager;
import org.apache.beam.it.common.TestProperties;
import org.apache.beam.it.testcontainers.TestContainerResourceManagerException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

public abstract class TestContainerResourceManager<@UnknownKeyFor T/*
 * Issues handling annotations - annotations may be inaccurate
 */
 extends @UnknownKeyFor @NonNull @Initialized GenericContainer<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>
implements ResourceManager {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(TestContainerResourceManager.class);
    protected static final @UnknownKeyFor @NonNull @Initialized String HOST_IP = TestProperties.hostIp();
    private final T container;
    private final @UnknownKeyFor @NonNull @Initialized boolean usingStaticContainer;
    private final @UnknownKeyFor @NonNull @Initialized String host;
    protected @UnknownKeyFor @NonNull @Initialized int port;

    protected <B extends Builder<?>> TestContainerResourceManager(T container, B builder) {
        this(container, builder, null);
    }

    protected <B extends Builder<?>> TestContainerResourceManager(T container, B builder, @Nullable @UnknownKeyFor @Initialized Callable<@UnknownKeyFor @Nullable @Initialized Void> setup) {
        this.container = container;
        this.usingStaticContainer = builder.useStaticContainer;
        this.host = builder.host == null ? HOST_IP : builder.host;
        this.port = builder.port;
        if (setup != null) {
            try {
                setup.call();
            }
            catch (Exception e) {
                throw new TestContainerResourceManagerException("Error running setup function.", e);
            }
        }
        if (!this.usingStaticContainer) {
            container.withLogConsumer(log -> LOG.info("{}: {}", (Object)container.getDockerImageName(), (Object)log.getUtf8String())).start();
        } else if (builder.host == null || builder.port < 0) {
            throw new TestContainerResourceManagerException("This manager was configured to use a static resource, but the host and port were not properly set.");
        }
    }

    protected @UnknownKeyFor @NonNull @Initialized String getDockerImageName() {
        return this.container.getDockerImageName();
    }

    public @UnknownKeyFor @NonNull @Initialized String getHost() {
        return this.host;
    }

    protected @UnknownKeyFor @NonNull @Initialized int getPort(@UnknownKeyFor @NonNull @Initialized int mappedPort) {
        if (this.port < 0) {
            return this.container.getMappedPort(mappedPort);
        }
        return this.port;
    }

    public void cleanupAll() throws @UnknownKeyFor @NonNull @Initialized TestContainerResourceManagerException {
        if (this.usingStaticContainer) {
            LOG.info("This manager was configured to use a static resource that will not be cleaned up.");
            return;
        }
        LOG.info("Attempting to cleanup TestContainers manager.");
        try {
            this.container.close();
            LOG.info("TestContainers manager successfully cleaned up.");
        }
        catch (Exception e) {
            throw new TestContainerResourceManagerException("Failed to close TestContainer resources", e);
        }
    }

    public static abstract class Builder<@UnknownKeyFor T/*
     * Issues handling annotations - annotations may be inaccurate
     */
     extends @UnknownKeyFor @NonNull @Initialized TestContainerResourceManager<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> {
        public @UnknownKeyFor @NonNull @Initialized String testId;
        public @UnknownKeyFor @NonNull @Initialized String containerImageName;
        public @UnknownKeyFor @NonNull @Initialized String containerImageTag;
        public @Nullable @UnknownKeyFor @Initialized String host;
        public @UnknownKeyFor @NonNull @Initialized int port;
        public @UnknownKeyFor @NonNull @Initialized boolean useStaticContainer;

        public Builder(@UnknownKeyFor @NonNull @Initialized String testId, @UnknownKeyFor @NonNull @Initialized String containerImageName, @UnknownKeyFor @NonNull @Initialized String containerImageTag) {
            this.testId = testId;
            this.containerImageName = containerImageName;
            this.containerImageTag = containerImageTag;
            this.host = null;
            this.port = -1;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder<T> setContainerImageName(@UnknownKeyFor @NonNull @Initialized String containerName) {
            this.containerImageName = containerName;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder<T> setContainerImageTag(@UnknownKeyFor @NonNull @Initialized String containerTag) {
            this.containerImageTag = containerTag;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder<T> setHost(@UnknownKeyFor @NonNull @Initialized String containerHost) {
            this.host = containerHost;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder<T> setPort(@UnknownKeyFor @NonNull @Initialized int port) {
            this.port = port;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder<T> useStaticContainer() {
            this.useStaticContainer = true;
            return this;
        }

        public abstract T build();
    }
}

