/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.it.conditions;

import java.util.function.Supplier;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConditionCheck
implements Supplier<Boolean> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ConditionCheck.class);
    private @Nullable @UnknownKeyFor @Initialized ConditionCheck prev = null;

    protected abstract @UnknownKeyFor @NonNull @Initialized String getDescription();

    protected abstract @UnknownKeyFor @NonNull @Initialized CheckResult check();

    @Override
    public @UnknownKeyFor @NonNull @Initialized Boolean get() {
        LOG.info("[?] Checking for condition '{}'...", (Object)this.getDescription());
        CheckResult result = this.check();
        if (!result.success) {
            LOG.info("[\u2717] Condition '{}' not met! {}", (Object)this.getDescription(), (Object)result.message);
            return false;
        }
        LOG.info("[\u2713] Condition '{}' succeeded! {}", (Object)this.getDescription(), (Object)(result.message == null ? "" : result.message));
        if (this.prev != null) {
            return result.success && this.prev.get() != false;
        }
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized ConditionCheck and(@UnknownKeyFor @NonNull @Initialized ConditionCheck next) {
        next.prev = this;
        return next;
    }

    public static class CheckResult {
        private final @UnknownKeyFor @NonNull @Initialized boolean success;
        private final @UnknownKeyFor @NonNull @Initialized String message;

        public CheckResult(@UnknownKeyFor @NonNull @Initialized boolean success) {
            this.success = success;
            this.message = "";
        }

        public CheckResult(@UnknownKeyFor @NonNull @Initialized boolean success, @UnknownKeyFor @NonNull @Initialized String message) {
            this.success = success;
            this.message = message;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isSuccess() {
            return this.success;
        }

        public @UnknownKeyFor @NonNull @Initialized String getMessage() {
            return this.message;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "CheckResult{success=" + this.success + ", message='" + this.message + '\'' + '}';
        }
    }
}

