/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.cdap.zendesk.options;

import org.apache.beam.examples.complete.cdap.options.BaseCdapOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.Validation;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface CdapZendeskOptions
extends BaseCdapOptions {
    @Validation.Required
    @Description(value="Zendesk base url.")
    public @UnknownKeyFor @NonNull @Initialized String getZendeskBaseUrl();

    public void setZendeskBaseUrl(@UnknownKeyFor @NonNull @Initialized String var1);

    @Validation.Required
    @Description(value="Zendesk admin email.")
    public @UnknownKeyFor @NonNull @Initialized String getAdminEmail();

    public void setAdminEmail(@UnknownKeyFor @NonNull @Initialized String var1);

    @Validation.Required
    @Description(value="Zendesk api token.")
    public @UnknownKeyFor @NonNull @Initialized String getApiToken();

    public void setApiToken(@UnknownKeyFor @NonNull @Initialized String var1);

    @Default.String(value="api/v2")
    @Description(value="Zendesk subdomains.")
    public @UnknownKeyFor @NonNull @Initialized String getSubdomains();

    public void setSubdomains(@UnknownKeyFor @NonNull @Initialized String var1);

    @Default.Integer(value=10000)
    @Description(value="Zendesk maxRetryCount.")
    public @UnknownKeyFor @NonNull @Initialized Integer getMaxRetryCount();

    public void setMaxRetryCount(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Default.Integer(value=10000)
    @Description(value="Zendesk maxRetryWait.")
    public @UnknownKeyFor @NonNull @Initialized Integer getMaxRetryWait();

    public void setMaxRetryWait(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Default.Integer(value=10000)
    @Description(value="Zendesk maxRetryJitterWait.")
    public @UnknownKeyFor @NonNull @Initialized Integer getMaxRetryJitterWait();

    public void setMaxRetryJitterWait(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Default.Integer(value=10)
    @Description(value="Zendesk connectTimeout.")
    public @UnknownKeyFor @NonNull @Initialized Integer getConnectTimeout();

    public void setConnectTimeout(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Default.Integer(value=10)
    @Description(value="Zendesk readTimeout.")
    public @UnknownKeyFor @NonNull @Initialized Integer getReadTimeout();

    public void setReadTimeout(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Validation.Required
    @Description(value="Zendesk objectsToPull.")
    public @UnknownKeyFor @NonNull @Initialized String getObjectsToPull();

    public void setObjectsToPull(@UnknownKeyFor @NonNull @Initialized String var1);

    @Validation.Required
    @Description(value="Path to output folder with filename prefix.It will write a set of .txt files with names like {prefix}-###.")
    public @UnknownKeyFor @NonNull @Initialized String getOutputTxtFilePathPrefix();

    public void setOutputTxtFilePathPrefix(@UnknownKeyFor @NonNull @Initialized String var1);
}

